<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

$has_secondary_text = noorgfx_akg( 'has_header_button_secondary_text', $atts, 'no' );


$iconSize = noorgfx_akg( 'cta_button_icon_size', $atts, 15 );

if ($iconSize !== 15) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-icon-size',
		'value' => $iconSize,
		'responsive' => true
	]);
}

$button_gap = noorgfx_akg( 'cta_button_gap', $atts, '0.5em' );

if ($button_gap !== '0.5em') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'theme-button-gap',
		'value' => $button_gap,
		'responsive' => true,
		'unit' => ''
	]);
}

noorgfx_output_font_css([
	'font_value' => noorgfx_akg('headerButtonFont', $atts,
		noorgfx_typography_default_values([])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'prefix' => 'button',
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '[class*="ct-button"]'
		])
	),
]);

// Font color
noorgfx_output_colors([
	'value' => noorgfx_akg('headerButtonFontColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

		'default_2' => [ 'color' => 'var(--theme-button-background-initial-color)' ],
		'hover_2' => [ 'color' => '#ffffff' ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button'
			])),
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button'
			])),
			'variable' => 'theme-button-text-hover-color'
		],


		'default_2' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button-ghost'
			])),
			'variable' => 'theme-button-text-initial-color'
		],

		'hover_2' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button-ghost'
			])),
			'variable' => 'theme-button-text-hover-color'
		],
	],
	'responsive' => true
]);


if ($has_secondary_text === 'yes') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button-text'
			])
		),
		'variableName' => 'horizontal-alignment',
		'value' => noorgfx_akg( 'header_button_text_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
		'unit' => '',
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_akg('headerButtonSecondaryLabelFont', $atts,
			noorgfx_typography_default_values([
				'size' => '12px',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'prefix' => 'button',
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-button-secondary-text'
			])
		),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('headerButtonSecondaryFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

			'default_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-button .ct-button-secondary-text'
				])),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-button .ct-button-secondary-text'
				])),
				'variable' => 'theme-button-text-hover-color'
			],


			'default_2' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-button-ghost .ct-button-secondary-text'
				])),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover_2' => [
				'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-button-ghost .ct-button-secondary-text'
				])),
				'variable' => 'theme-button-text-hover-color'
			],
		],
		'responsive' => true
	]);
}

// Background color
noorgfx_output_colors([
	'value' => noorgfx_akg('headerButtonForeground', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-button-background-hover-color'
		],
	],
	'responsive' => true
]);

if (isset($has_transparent_header) && $has_transparent_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderButtonFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

			'default_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button'
						]),

						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],

			'default_2' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button-ghost'
						]),

						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover_2' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button-ghost'
						]),

						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],
		],
		'responsive' => true
	]);

	if ($has_secondary_text === 'yes') {
		noorgfx_output_colors([
			'value' => noorgfx_akg('transparentHeaderButtonSecondaryFontColor', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

				'default_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button .ct-button-secondary-text'
							]),
							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-button-text-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-button-text-hover-color'
				],

				'default_2' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button-ghost .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-button-text-initial-color'
				],

				'hover_2' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button-ghost .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-transparent-row="yes"]'
						])
					),
					'variable' => 'theme-button-text-hover-color'
				],
			],
			'responsive' => true
		]);
	}

	// Background color
	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderButtonForeground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-background-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-button-background-hover-color'
			],
		],
		'responsive' => true
	]);
}


// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderButtonFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

			'default_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button'
						]),

						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button'
						]),

						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],

			'default_2' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button-ghost'
						]),

						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover_2' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.ct-button-ghost'
						]),

						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-text-hover-color'
			],
		],
		'responsive' => true
	]);


	if ($has_secondary_text === 'yes') {
		noorgfx_output_colors([
			'value' => noorgfx_akg('stickyHeaderButtonSecondaryFontColor', $atts),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

				'default_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-button-text-initial-color'
				],

				'hover' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-button-text-hover-color'
				],

				'default_2' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button-ghost .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-button-text-initial-color'
				],

				'hover_2' => [
					'selector' => noorgfx_assemble_selector(
						noorgfx_mutate_selector([
							'selector' => noorgfx_mutate_selector([
								'selector' => $root_selector,
								'operation' => 'suffix',
								'to_add' => '.ct-button-ghost .ct-button-secondary-text'
							]),

							'operation' => 'between',
							'to_add' => '[data-sticky*="yes"]'
						])
					),
					'variable' => 'theme-button-text-hover-color'
				],
			],
			'responsive' => true
		]);
	}


	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderButtonForeground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-background-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-button-background-hover-color'
			],
		],
		'responsive' => true
	]);
}

// Border radius
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'property' => 'theme-button-border-radius',
	'value' => noorgfx_default_akg(
		'headerCtaRadius',
		$atts,
		noorgfx_spacing_value()
	),
	'empty_value' => ''
]);

// Padding
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => 'a'
		])
	),
	'property' => 'theme-button-padding',
	'value' => noorgfx_default_akg(
		'headerCtaPadding',
		$atts,
		noorgfx_spacing_value()
	),
	'empty_value' => ''
]);

// Margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
    'important' => true,
	'value' => noorgfx_default_akg(
		'headerCtaMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);


// footer button
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $column_selector
	])),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'footer_button_horizontal_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $column_selector
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg( 'footer_button_vertical_alignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);
