<?php

if (! isset($selector)) {
	$selector = '[data-column="widget-area-1"]';
}

$text_horizontal_alignment = noorgfx_akg(
	'horizontal_alignment',
	$atts,
	'CT_CSS_SKIP_RULE'
);

$horizontal_alignment = $text_horizontal_alignment;

$horizontal_alignment = noorgfx_map_values([
	'value' => $text_horizontal_alignment,
	'map' => [
		'left' => 'flex-start',
		'right' => 'flex-end'
	]
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $selector
	])),
	'variableName' => 'text-horizontal-alignment',
	'value' => $text_horizontal_alignment,
	'unit' => '',
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $selector
	])),
	'variableName' => 'horizontal-alignment',
	'value' => $horizontal_alignment,
	'unit' => '',
]);


noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $selector
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg('vertical_alignment', $atts, 'CT_CSS_SKIP_RULE'),
	'unit' => '',
]);

// Font color
noorgfx_output_colors([
	'value' => noorgfx_akg('widget_area_colors', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		'link_initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		'link_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'replace-last',
						'to_add' => $selector
					]),
					'operation' => 'suffix',
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-text-color'
		],

		'link_initial' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'replace-last',
						'to_add' => $selector
					]),
					'operation' => 'suffix',
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-link-initial-color'
		],

		'link_hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'replace-last',
						'to_add' => $selector
					]),
					'operation' => 'suffix',
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => $selector
	])),
	'important' => true,
	'value' => noorgfx_default_akg(
		'widget_area_margin',
		$atts,
		noorgfx_spacing_value()
	)
]);
