<?php

if (empty($default_background)) {
	$default_background = noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => 'transparent'
			],
		],
	]);
}

if (empty($default_top_bottom_spacing)) {
	$default_top_bottom_spacing = [
		'desktop' => '70px',
		'tablet' => '50px',
		'mobile' => '40px',
	];
}

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'items_per_row' => [
				'label' => __( 'Columns', 'noorgfx' ),
				'type' => 'ct-radio',
				'value' => '3',
				'view' => 'text',
				'design' => 'block',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'1' => 1,
					'2' => 2,
					'3' => 3,
					'4' => 4,
					'5' => 5,
					'6' => 6,
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '2' ],
				'options' => [

					'2_columns_layout' => [
						'label' => __( 'Columns Layout', 'noorgfx' ),
						'type' => 'ct-image-picker',
						'attr' => ['data-ratio' => '2:1'],
						'value' => [
							'desktop' => 'repeat(2, 1fr)',
							'tablet' => 'initial',
							'mobile' => 'initial'
						],
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
							],

							'2fr 1fr' => [
								'src' => noorgfx_image_picker_file( '2-1' ),
							],

							'1fr 2fr' => [
								'src' => noorgfx_image_picker_file( '1-2' ),
							],

							'3fr 1fr' => [
								'src' => noorgfx_image_picker_file( '3-1' ),
							],

							'1fr 3fr' => [
								'src' => noorgfx_image_picker_file( '1-3' ),
							],
						],

						'tabletChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],

						'mobileChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '3' ],
				'options' => [

					'3_columns_layout' => [
						'label' => __( 'Columns Layout', 'noorgfx' ),
						'type' => 'ct-image-picker',
						'attr' => ['data-ratio' => '2:1'],
						'value' => [
							'desktop' => 'repeat(3, 1fr)',
							'tablet' => 'initial',
							'mobile' => 'initial',
						],
						'responsive' => true,
						'divider' => 'top',
						'setting' => ['transport' => 'postMessage'],
						'choices' => [
							'repeat(3, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1-1' ),
							],

							'1fr 2fr 1fr' => [
								'src' => noorgfx_image_picker_file( '1-2-1' ),
							],

							'2fr 1fr 1fr' => [
								'src' => noorgfx_image_picker_file( '2-1-1' ),
							],

							'1fr 1fr 2fr' => [
								'src' => noorgfx_image_picker_file( '1-1-2' ),
							],
						],

						'tabletChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],

						'mobileChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '4' ],
				'options' => [

					'4_columns_layout' => [
						'label' => __( 'Columns Layout', 'noorgfx' ),
						'type' => 'ct-image-picker',
						'attr' => ['data-ratio' => '2:1'],
						'value' => [
							'desktop' => 'repeat(4, 1fr)',
							'tablet' => 'initial',
							'mobile' => 'initial'
						],
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'repeat(4, 1fr)' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-1' ),
							],

							'1fr 2fr 2fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '1-2-2-1' ),
							],

							'2fr 1fr 1fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '2-1-1-1' ),
							],

							'1fr 1fr 1fr 2fr' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-2' ),
							],
						],

						'tabletChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],

						'mobileChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '5' ],
				'options' => [

					'5_columns_layout' => [
						'label' => __( 'Columns Layout', 'noorgfx' ),
						'type' => 'ct-image-picker',
						'attr' => ['data-ratio' => '2:1'],
						'value' => [
							'desktop' => 'repeat(5, 1fr)',
							'tablet' => 'initial',
							'mobile' => 'initial'
						],
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'repeat(5, 1fr)' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-1-1' ),
							],

							'2fr 1fr 1fr 1fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '2-1-1-1-1' ),
							],

							'1fr 1fr 1fr 1fr 2fr' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-1-2' ),
							],

							'1fr 1fr 2fr 1fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '1-1-2-1-1' ),
							],
						],

						'tabletChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],

						'mobileChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '6' ],
				'options' => [

					'6_columns_layout' => [
						'label' => __( 'Columns Layout', 'noorgfx' ),
						'type' => 'ct-image-picker',
						'attr' => ['data-ratio' => '2:1'],
						'value' => [
							'desktop' => 'repeat(6, 1fr)',
							'tablet' => 'initial',
							'mobile' => 'initial'
						],
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'repeat(6, 1fr)' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-1-1-1' ),
							],

							'2fr 1fr 1fr 1fr 1fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '2-1-1-1-1-1' ),
							],

							'1fr 1fr 1fr 1fr 1fr 2fr' => [
								'src'   => noorgfx_image_picker_file( '1-1-1-1-1-2' ),
							],

							'1fr 1fr 2fr 2fr 1fr 1fr' => [
								'src'   => noorgfx_image_picker_file( '1-1-2-2-1-1' ),
							],
						],

						'tabletChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],

						'mobileChoices' => [
							'initial' => [
								'src' => noorgfx_image_picker_file( 'stacked' ),
								'title' => __( 'Stacked', 'noorgfx' ),
							],

							'repeat(2, 1fr)' => [
								'src' => noorgfx_image_picker_file( '1-1' ),
								'title' => __( 'Two Columns', 'noorgfx' ),
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '!1' ],
				'options' => [

					'footerItemsGap' => [
						'label' => __( 'Columns Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 0,
						'max' => 500,
						'value' => 50,
						'responsive' => true,
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			'footerWidgetsGap' => [
				'label' => __( 'Widgets Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 0,
				'max' => 200,
				'value' => 40,
				'responsive' => true,
				'divider' => 'bottom',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'rowTopBottomSpacing' => [
				'label' => __( 'Row Vertical Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => $default_top_bottom_spacing,
				'units' => noorgfx_units_config([
					[ 'unit' => 'px', 'min' => 0, 'max' => 500 ],
				]),
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'footer_row_vertical_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Vertical Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'responsive' => true,
				'attr' => [ 'data-type' => 'vertical-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'flex-start',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			'footerRowWidth' => [
				'label' => __( 'Container Width', 'noorgfx' ),
				'type' => 'ct-radio',
				'value' => 'fixed',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => [
					'fixed' => __( 'Default', 'noorgfx' ),
					'fluid' => __( 'Full Width', 'noorgfx' ),
				],
			],

			'footerRowVisibility' => [
				'label' => __( 'Row Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_widget_areas' => 'yes' ],
				'options' => [
					'footerWidgetsTitleFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Widgets Title Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '16px',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'footerWidgetsTitleColor' => [
						'label' => __( 'Widgets Title Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit_source' => 'global',
								'inherit' => [
									'var(--theme-heading-1-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h1'
									],

									'var(--theme-heading-2-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h2'
									],

									'var(--theme-heading-3-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h3'
									],

									'var(--theme-heading-4-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h4'
									],

									'var(--theme-heading-5-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h5'
									],

									'var(--theme-heading-6-color, var(--theme-headings-color))' => [
										'widgets_title_wrapper' => 'h6'
									]
								]
							],
						],
					],

					'footerWidgetsFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Widgets Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							// 'size' => '16px',
						]),
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'rowFontColor' => [
						'label' => __( 'Widgets Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'link_hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Link Initial', 'noorgfx' ),
								'id' => 'link_initial',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx' ),
								'id' => 'link_hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			'footerRowBackground' => [
				'label' => __( 'Row Background', 'noorgfx' ),
				'type'  => 'ct-background',
				'design' => 'block:right',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => $default_background
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footerRowTopDivider' => [
				'label' => __( 'Row Top Divider', 'noorgfx' ),
				'type' => 'ct-border',
				'design' => 'block',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => [
					'width' => 1,
					'style' => 'none',
					'color' => [
						'color' => '#dddddd',
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'footerRowTopDivider/style:responsive' => '!none' ],
				'options' => [

					'footerRowTopBorderFullWidth' => [
						'label' => __( 'Top Border Width', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'no',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'no' => __( 'Default', 'noorgfx' ),
							'yes' => __( 'Full Width', 'noorgfx' ),
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footerRowBottomDivider' => [
				'label' => __( 'Row Bottom Divider', 'noorgfx' ),
				'type' => 'ct-border',
				'design' => 'block',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => [
					'width' => 1,
					'style' => 'none',
					'color' => [
						'color' => '#dddddd',
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'footerRowBottomDivider/style:responsive' => '!none' ],
				'options' => [

					'footerRowBottomBorderFullWidth' => [
						'label' => __( 'Bottom Border Width', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'no',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'no' => __( 'Default', 'noorgfx' ),
							'yes' => __( 'Full Width', 'noorgfx' ),
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'items_per_row' => '!1' ],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'footerColumnsDivider' => [
						'label' => __( 'Columns Divider', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => '#dddddd',
							],
						]
					],

				],
			],
		],
	],
];
