<?php

if (! isset($location)) {
	$location = 'Footer Menu';
}

$options = [
	'menu' => [
		'label' => __('Select Menu', 'noorgfx'),
		'type' => 'ct-select',
		'value' => 'noorgfx_location',
		'view' => 'text',
		'design' => 'inline',
		'setting' => [ 'transport' => 'postMessage' ],
		'placeholder' => __('Select menu...', 'noorgfx'),
		'choices' => noorgfx_ordered_keys(noorgfx_get_menus_items($location)),
		'desc' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual URL.
			__( 'Manage your menus in the %sMenus screen%s.', 'noorgfx' ),
			noorgfx_safe_sprintf(
				'<a href="%s" target="_blank">',
				admin_url('/nav-menus.php')
			),
			'</a>'
		),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			'menu_items_direction' => [
				'type' => 'ct-radio',
				'label' => __( 'Items Direction', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'horizontal',
				'choices' => [
					'horizontal' => __( 'Horizontal', 'noorgfx' ),
					'vertical' => __( 'Vertical', 'noorgfx' ),
				],
			],

			'footerMenuItemsSpacing' => [
				'label' => __( 'Items Spacing', 'noorgfx' ),
				'type' => 'ct-slider',
				'value' => 25,
				'min' => 5,
				'max' => 100,
				'divider' => 'top',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_items_direction:responsive' => 'horizontal' ],
				'options' => [

					'stretch_menu' => [
						'label' => __( 'Stretch Menu', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top',
						'desc' => __('Enabling this option will make the menu to stretch and fit the width of its parent column. ', 'noorgfx'),
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footerMenuAlignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Horizontal Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'attr' => [ 'data-type' => 'alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_items_direction' => 'horizontal' ],
				'options' => [

					'footerMenuVerticalAlignment' => [
						'type' => 'ct-radio',
						'label' => __( 'Vertical Alignment', 'noorgfx' ),
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'attr' => [ 'data-type' => 'vertical-alignment' ],
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => 'CT_CSS_SKIP_RULE',
						'choices' => [
							'flex-start' => '',
							'center' => '',
							'flex-end' => '',
						],
					],

				],
			],

			'footer_menu_visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'footerMenuFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '12px',
					'variation' => 'n7',
					'line-height' => '1.3',
					'text-transform' => 'uppercase',
				]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'footerMenuFontColor' => [
				'label' => __( 'Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'var(--theme-text-color)',
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'active' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)',
					],

					[
						'title' => __( 'Active', 'noorgfx' ),
						'id' => 'active',
						'inherit' => 'self:hover'
					],
				],
			],

			'footerMenuMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];
