<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Box shadow
$has_reveal_effect = noorgfx_akg('has_reveal_effect', $atts,  [
	'desktop' => false,
	'tablet' => false,
	'mobile' => false,
]);

if (function_exists('noorgfx_output_responsive_switch')) {
	noorgfx_output_responsive_switch([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-footer'
				]),
				'operation' => 'container-suffix',
				'to_add' => '[data-footer*="reveal"]'
			])
		),
		'variable' => 'position',
		'on' => 'sticky',
		'off' => 'static',
		'value' => $has_reveal_effect,
		'skip_when' => 'all_disabled'
	]);
}

if (
	(
		function_exists('noorgfx_some_device')
		&&
		noorgfx_some_device($has_reveal_effect)
	)
	||
	is_customize_preview()
) {
	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.site-main'
				]),
				'operation' => 'container-suffix',
				'to_add' => '[data-footer*="reveal"]'
			])
		),
		'value' => noorgfx_akg('footerShadow', $atts, noorgfx_box_shadow_value([
			'enable' => true,
			'h_offset' => 0,
			'v_offset' => 30,
			'blur' => 50,
			'spread' => 0,
			'inset' => false,
			'color' => [
				'color' => 'rgba(0, 0, 0, 0.1)',
			],
		])),
		'variableName' => 'footer-box-shadow',
		'responsive' => $has_reveal_effect,
		'should_skip_output' => false
	]);
}

noorgfx_output_background_css([
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.ct-footer'
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_akg(
		'footerBackground',
		$atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => 'var(--theme-palette-color-6)'
				],
			],
		])
	),
	'responsive' => true,
]);

$footer_container_structure = noorgfx_akg('footer_container_structure', $atts, 'fixed');

if ($footer_container_structure !== 'boxed' || is_customize_preview()) {
	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.ct-footer'
			])
		),
		'property' => 'footer-container-padding',
		'value' => noorgfx_akg('footer_spacing', $atts, noorgfx_spacing_value())
	]);
}

if ($footer_container_structure === 'boxed' || is_customize_preview()) {

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => 'footer.ct-container'
			])
		),
		'variableName' => 'footer-container-bottom-offset',
		'value' => noorgfx_akg('footer_boxed_offset', $atts, 50)
	]);
	
	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => 'footer.ct-container'
			])
		),
		'property' => 'footer-container-padding',
		'value' => noorgfx_akg('footer_boxed_spacing', $atts,
			[
				'desktop' => noorgfx_spacing_value([
					'top' => '0px',
					'left' => '35px',
					'right' => '35px',
					'bottom' => '0px',
				]),
				'tablet' => noorgfx_spacing_value([
					'top' => '0vw',
					'left' => '4vw',
					'right' => '4vw',
					'bottom' => '0vw',
				]),
				'mobile'=> noorgfx_spacing_value([
					'top' => '0vw',
					'left' => '5vw',
					'right' => '5vw',
					'bottom' => '0vw',
				]),
			]
		)
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => 'footer.ct-container'
			])
		),
		'property' => 'footer-container-border-radius',
		'value' => noorgfx_akg('footer_container_border_radius', $atts, noorgfx_spacing_value())
	]);
}
