<?php

$class = 'ct-footer-copyright';

$class = trim($class . ' ' . noorgfx_visibility_classes(noorgfx_default_akg(
	'footer_copyright_visibility',
	$atts,
	[
		'desktop' => true,
		'tablet' => true,
		'mobile' => true,
	]
)));

$theme = noorgfx_get_wp_theme();

$text = str_replace(
	'{current_year}',
	date("Y"),
	apply_filters(
		'noorgfx:footer:copyright:value',
		noorgfx_translate_dynamic(
			noorgfx_default_akg(
				'copyright_text',
				$atts,
				apply_filters(
					'noorgfx:footer:copyright:default-value',
					__(
						'Copyright &copy; {current_year} - WordPress Theme by {theme_author}',
						'noorgfx'
					)
				)
			),
			'footer:' . $section_id . ':copyright:copyright_text'
		)
	)
);

$text = str_replace(
	'{site_title}',
	get_bloginfo('name'),
	$text
);

$text = noorgfx_output_html_safely(str_replace(
	'{theme_author}',
	noorgfx_html_tag(
		'a',
		[
			'href' => $theme->get('AuthorURI')
		],
		$theme->get('Author')
	),
	$text
));

?>

<div
	class="<?php echo esc_attr($class) ?>"
	<?php echo noorgfx_attr_to_html($attr) ?>>

	<?php echo $text ?>
</div>
