<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Font
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'copyrightFont', $atts,
		noorgfx_typography_default_values([
			'size' => '15px',
			'variation' => 'n4',
			'line-height' => '1.3',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector)
]);

// Font color
noorgfx_output_colors([
	'value' => noorgfx_akg('copyrightColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'link_initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'link_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-text-color'
		],

		'link_initial' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-link-initial-color'
		],

		'link_hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'theme-link-hover-color'
		],
	],
]);

// Alignment
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,

	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="copyright"]'
	])),

	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg('footerCopyrightAlignment', $atts, 'CT_CSS_SKIP_RULE'),
	'unit' => '',
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="copyright"]'
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg('footerCopyrightVerticalAlignment', $atts, 'CT_CSS_SKIP_RULE'),
	'unit' => '',
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'copyrightMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);
