<?php

$options = [
	'woo_product_gallery' => [
		'label' => __( 'Product Gallery', 'noorgfx' ),
		'type' => 'ct-panel',
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					apply_filters(
						'noorgfx:options:single_product:product-general-tab:start',
						[
							'product_view_type' => [
								'type' => 'hidden',
								'value' => 'default-gallery'
							]
						]
					),

					[
						[
							'has_product_single_lightbox' => [
								'label' => __( 'Lightbox', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'no',
								'divider' => 'top:full',
								'sync' => noorgfx_sync_whole_page([
									'prefix' => 'product',
									'loader_selector' => '.woocommerce-product-gallery'
								]),
							],
	
							'has_product_single_zoom' => [
								'label' => __( 'Zoom Effect', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'sync' => noorgfx_sync_whole_page([
									'prefix' => 'product',
									'loader_selector' => '.woocommerce-product-gallery'
								]),
							],
	
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [
									'product_view_type' => 'default-gallery|stacked-gallery'
								],
								'options' => [
									'has_product_sticky_gallery' => [
										'label' => __('Sticky Gallery', 'noorgfx'),
										'type' => 'ct-switch',
										'value' => 'no',
										'sync' => 'live'
									],
								],
							],
						],

						[
							apply_filters(
								'noorgfx:options:single_product:product-general-tab:sticky:after',
								[]
							),
						],

						[
							noorgfx_rand_md5() => [
								'type' => 'ct-divider',
							],
						]

					],

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'product_view_type' => 'default-gallery|stacked-gallery',
							],
							'options' => [

								'productGalleryWidth' => [
									'label' => __( 'Container Width', 'noorgfx' ),
									'type' => 'ct-slider',
									'defaultUnit' => '%',
									'value' => 50,
									'min' => 20,
									'max' => 70,
									'divider' => 'bottom',
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],
						],

						'product_gallery_ratio' => [
							'label' => __( 'Image Ratio', 'noorgfx' ),
							'type' => 'ct-ratio',
							'value' => '3/4',
							'design' => 'block',
							'attr' => [ 'data-type' => 'compact' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'preview_width_key' => 'woocommerce_single_image_width',
							'view' => 'inline',
							'inner-options' => [

								'woocommerce_single_image_width' => [
									'type' => 'text',
									'label' => __('Image Size', 'noorgfx'),
									'desc' => __('Image size used for the main image on single product pages.', 'noorgfx'),
									'value' => 600,
									'design' => 'inline',
									'setting' => [
										'type' => 'option',
										'capability' => 'manage_woocommerce',
									]
								],

							],
						],

					],

					apply_filters(
						'noorgfx:options:single_product:gallery-options',
						[]
					),

					apply_filters(
						'noorgfx:options:single_product:gallery:arrows',
						[]
					),

				],
			],


			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'slider_nav_arrow_color' => [
						'label' => __( 'Prev/Next Arrow', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => '#ffffff'
							],
						],
					],

					'slider_nav_background_color' => [
						'label' => __( 'Prev/Next Background', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => '#ffffff'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-1)'
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'has_product_single_lightbox' => 'yes' ],
						'options' => [

							'lightbox_button_icon_color' => [
								'label' => __( 'Lightbox Button Icon Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => '#ffffff'
									],
								],
							],

							'lightbox_button_background_color' => [
								'label' => __( 'Lightbox Button Background', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => '#ffffff'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-palette-color-1)'
									],
								],
							],

						],
					],

					'product_image_border_radius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'sync' => 'live',
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true
					],

				],
			],



			// gallery thumbnails
			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 
					'product_view_type' => 'default-gallery|top-gallery'
				],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'label' => __( 'Gallery Thumbnails', 'noorgfx' ),
					],

					noorgfx_rand_md5() => [
						'title' => __( 'General', 'noorgfx' ),
						'type' => 'tab',
						'options' => [

							[

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [ 'product_view_type' => 'default-gallery' ],
									'options' => [

										'gallery_style' => [
											'label' => __('Position', 'noorgfx'),
											'type' => 'ct-radio',
											'value' => 'horizontal',
											'view' => 'text',
											'design' => 'block',
											'divider' => 'bottom',
											'choices' => [
												'horizontal' => __( 'Horizontal', 'noorgfx' ),
												'vertical' => __( 'Vertical', 'noorgfx' ),
											],

											'sync' => noorgfx_sync_whole_page([
												'loader_selector' => '.woocommerce-product-gallery',
												'prefix' => 'product'
											])
										],

									],
								],

								'gallery_thumbnail_image_width' => [
									'type' => 'text',
									'label' => __('Image Size', 'noorgfx'),
									'desc' => __('Image size used for the gallery thumbnails on single product pages.', 'noorgfx'),
									'value' => 100,
									'design' => 'inline',
									'divider' => 'bottom',
								],

								'product_thumbs_spacing' => [
									'label' => __( 'Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => '15px',
									'units' => noorgfx_units_config([
										[ 'unit' => 'px', 'min' => 0, 'max' => 100 ],
									]),
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
								],

							],

							apply_filters(
								'noorgfx:options:single_product:gallery-thumbs:arrows',
								[]
							),

						],
					],

					noorgfx_rand_md5() => [
						'title' => __( 'Design', 'noorgfx' ),
						'type' => 'tab',
						'options' => [

							'product_thumbs_border_radius' => [
								'label' => __( 'Border Radius', 'noorgfx' ),
								'sync' => 'live',
								'type' => 'ct-spacing',
								'divider' => 'top',
								'value' => noorgfx_spacing_value(),
								'responsive' => true
							],

						],
					],

				],
			],

		],
	],
];
