<?php

$woo_single_layout_left_value = noorgfx_get_woo_single_layout_defaults('left');

$woo_single_layout_right_value = noorgfx_get_woo_single_layout_defaults('right');

$options = [
	'woo_product_elements' => [
		'label' => __('Product Elements', 'noorgfx'),
		'type' => 'ct-panel',
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __('General', 'noorgfx'),
				'type' => 'tab',
				'options' => [
					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'product_view_type' => 'default-gallery|stacked-gallery'
							],
							'options' => [
								'woo_single_layout' => [
									'label' => false,
									'type' => 'ct-layers',
									'manageable' => false,
									'sync' => [
										noorgfx_sync_whole_page([
											'prefix' => 'product',
											'loader_selector' => '.entry-summary-items'
										]),

										[
											'prefix' => 'product',
											'id' => 'woo_single_layout_skip',
											'loader_selector' => 'skip',
											'container_inclusive' => false
										],

										[
											'prefix' => 'product',
											'id' => 'product_payment_methods',
											'loader_selector' => '.entry-summary-items .ct-payment-methods',
											'container_inclusive' => false
										]

									],
									'value' => noorgfx_get_woo_single_layout_defaults(),
									'settings' => noorgfx_get_options('woocommerce/single-product-layers'),
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'product_view_type' => 'columns-top-gallery|top-gallery'
							],
							'options' => [
								'woo_single_split_layout' => [
									'type' => 'ct-layers-combined',
									'design' => 'none',
									'value' => [
										'left' => $woo_single_layout_left_value,
										'right' => $woo_single_layout_right_value
									],
									'sync' => [
										'id' => 'woo_single_layout'
									],
									'inner-options' => [
										'left' => [
											'label' => __('Left Column', 'noorgfx'),
											'type' => 'ct-layers',
											'manageable' => false,
											'grouped' => true,
											'value' => $woo_single_layout_left_value,
											'settings' => noorgfx_get_options(
												'woocommerce/single-product-layers'
											),
											'attr' => [
												'class' => 'ct-layers-split-layout'
											]
										],

										'right' => [
											'label' => __('Right Column', 'noorgfx'),
											'type' => 'ct-layers',
											'manageable' => false,
											'grouped' => true,
											'value' => $woo_single_layout_right_value,
											'settings' => noorgfx_get_options(
												'woocommerce/single-product-layers'
											),
											'attr' => [
												'class' => 'ct-layers-split-layout'
											]
										],
									]
								],
							]
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],
					],

					apply_filters('noorgfx_woo_single_options:after_layers', []),

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							'product_view_type' => 'default-gallery|stacked-gallery'
						],
						'options' => [
							'has_product_sticky_summary' => [
								'label' => __('Sticky Container', 'noorgfx'),
								'type' => 'ct-switch',
								'value' => 'no',
								'sync' => 'live',
							],
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'title' => __('Design', 'noorgfx'),
				'type' => 'tab',
				'options' => [
					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['woo_single_layout:array-ids:product_title:enabled' => '!no'],
							'computed_fields' => ['woo_single_layout'],
							'options' => [

								'singleProductTitleFont' => [
									'type' => 'ct-typography',
									'label' => __('Title Font', 'noorgfx'),
									'value' => noorgfx_typography_default_values([
										'size' => '30px',
									]),
									'setting' => ['transport' => 'postMessage'],
								],

								'singleProductTitleColor' => [
									'label' => __('Title Font Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'setting' => ['transport' => 'postMessage'],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--theme-heading-1-color, var(--theme-headings-color))'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['woo_single_layout:array-ids:product_price:enabled' => '!no'],
							'computed_fields' => ['woo_single_layout'],
							'options' => [

								'singleProductPriceFont' => [
									'type' => 'ct-typography',
									'label' => __('Price Font', 'noorgfx'),
									'value' => noorgfx_typography_default_values([
										'size' => '20px',
										'variation' => 'n7',
									]),
									'setting' => ['transport' => 'postMessage'],
									'divider' => 'top:full',
								],

								'singleProductPriceColor' => [
									'label' => __('Price Font Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'setting' => ['transport' => 'postMessage'],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['woo_single_layout:array-ids:product_breadcrumbs:enabled' => '!no'],
							'computed_fields' => ['woo_single_layout'],
							'options' => [

								'singleProductBreadcrumbsFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Breadcrumbs Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([]),
									'design' => 'block',
									'sync' => 'live',
									'divider' => 'top:full',
								],

								'singleProductBreadcrumbsFontColor' => [
									'label' => __( 'Breadcrumbs Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'sync' => 'live',

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'initial' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Text', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],

										[
											'title' => __( 'Link Initial', 'noorgfx' ),
											'id' => 'initial',
											'inherit' => 'var(--theme-link-initial-color)'
										],

										[
											'title' => __( 'Link Hover', 'noorgfx' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-link-hover-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['woo_single_layout:array-ids:product_add_to_cart:enabled' => '!no'],
							'computed_fields' => ['woo_single_layout'],
							'options' => [

								'quantity_color' => [
									'label' => __('Quantity Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'divider' => 'top:full',
									'sync' => 'live',
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--quantity-initial-color, var(--theme-button-background-initial-color))'
										],

										[
											'title' => __('Hover', 'noorgfx'),
											'id' => 'hover',
											'inherit' => 'var(--quantity-hover-color, var(--theme-button-background-hover-color))'
										],
									],
								],

								'quantity_arrows' => [
									'label' => __('Quantity Arrows Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'sync' => 'live',
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'default_type_2' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--quantity-arrows-initial-color, #fff)',
											'condition_source' => 'global',
											'condition' => ['quantity_type' => 'type-1']
										],

										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default_type_2',
											'inherit' => 'var(--quantity-arrows-initial-color, var(--theme-text-color))',
											'condition_source' => 'global',
											'condition' => ['quantity_type' => 'type-2']
										],

										[
											'title' => __('Hover', 'noorgfx'),
											'id' => 'hover',
											'inherit' => 'var(--quantity-arrows-hover-color, #fff)'
										],
									],
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'variation' => 'small-divider',
									'label' => __('Add To Cart Button', 'noorgfx'),
								],

								'add_to_cart_text' => [
									'label' => __('Button Font Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									// 'responsive' => true,
									'sync' => 'live',
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--theme-button-text-initial-color)',
										],

										[
											'title' => __('Hover', 'noorgfx'),
											'id' => 'hover',
											'inherit' => 'var(--theme-button-text-hover-color)',
										],
									],
								],

								'add_to_cart_background' => [
									'label' => __('Button Background Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									// 'responsive' => true,
									'sync' => 'live',
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
											'inherit' => 'var(--theme-button-background-initial-color)'
										],

										[
											'title' => __('Hover', 'noorgfx'),
											'id' => 'hover',
											'inherit' => 'var(--theme-button-background-hover-color)'
										],
									],
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => ['has_ajax_add_to_cart' => 'yes'],
									'options' => [

										noorgfx_rand_md5() => [
											'type' => 'ct-title',
											'variation' => 'small-divider',
											'label' => __('View Cart Button', 'noorgfx'),
										],

										'view_cart_button_text' => [
											'label' => __('Button Font Color', 'noorgfx'),
											'type'  => 'ct-color-picker',
											'design' => 'inline',
											// 'responsive' => true,
											'sync' => 'live',
											'value' => [
												'default' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],

												'hover' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],
											],

											'pickers' => [
												[
													'title' => __('Initial', 'noorgfx'),
													'id' => 'default',
													'inherit' => 'var(--theme-text-color)',
												],

												[
													'title' => __('Hover', 'noorgfx'),
													'id' => 'hover',
													'inherit' => 'var(--theme-text-color)',
												],
											],
										],

										'view_cart_button_background' => [
											'label' => __('Button Background Color', 'noorgfx'),
											'type'  => 'ct-color-picker',
											'design' => 'inline',
											// 'responsive' => true,
											'sync' => 'live',
											'value' => [
												'default' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],

												'hover' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],
											],

											'pickers' => [
												[
													'title' => __('Initial', 'noorgfx'),
													'id' => 'default',
													'inherit' => 'rgba(224,229,235,0.6)'
												],

												[
													'title' => __('Hover', 'noorgfx'),
													'id' => 'hover',
													'inherit' => 'rgba(224,229,235,1)'
												],
											],
										],

									],
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['woo_single_layout:array-ids:divider:enabled' => '!no'],
							'computed_fields' => ['woo_single_layout'],
							'options' => [

								'woo_single_layers_divider' => [
									'label' => __( 'Divider', 'noorgfx' ),
									'type' => 'ct-border',
									'sync' => 'live',
									'design' => 'inline',
									'divider' => 'top:full',
									'value' => [
										'width' => 1,
										'style' => 'solid',
										'color' => [
											'color' => 'var(--theme-border-color)',
										],
									]
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'woo_single_layout:array-ids:product_payment_methods:enabled' => '!no',
								'woo_single_layout:array-ids:product_payment_methods:payment_icons_color' => 'custom'
							],
							'computed_fields' => [
								'woo_single_layout'
							],
							'options' => [

								'payment_method_icons_color' => [
									'label' => __('Payment Methods Icons Color', 'noorgfx'),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'divider' => 'top:full',
									'setting' => ['transport' => 'postMessage'],

									'value' => [
										'default' => [
											'color' => '#4B4F58',
										],
									],

									'pickers' => [
										[
											'title' => __('Initial', 'noorgfx'),
											'id' => 'default',
										],
									],
								],

							],
						],

					],

					apply_filters(
						'noorgfx:options:single_product:elements:design_tab:end',
						[]
					),

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'product_view_type' => 'columns-top-gallery|top-gallery'
							],
							'options' => [

								'entry_summary_container_border' => [
									'label' => __( 'Container Border', 'noorgfx' ),
									'type' => 'ct-border',
									'sync' => 'live',
									'design' => 'inline',
									'divider' => 'top:full',
									'value' => [
										'width' => 1,
										'style' => 'solid',
										'color' => [
											'color' => 'var(--theme-border-color)',
										],
									]
								],

								'entry_summary_container_border_radius' => [
									'label' => __( 'Container Border Radius', 'noorgfx' ),
									'sync' => 'live',
									'type' => 'ct-spacing',
									'divider' => 'top',
									'value' => noorgfx_spacing_value(),
									'min' => 0,
									'responsive' => true
								],

							],
						],
					]
				],
			],

		],
	],
];
