<?php
/**
 * Store notice options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'woocommerce_demo_store' => [
		'label' => __('Store Notice', 'noorgfx'),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'no',
		'switchBehavior' => 'boolean',
		'setting' => [
			'type' => 'option',
		],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'woocommerce_demo_store_notice' => [
						'label' => false,
						'type' => 'textarea',
						'value' => __( 'This is a demo store for testing purposes &mdash; no orders shall be fulfilled.', 'noorgfx' ),
						'setting' => [
							'type' => 'option',
							'transport' => 'postMessage'
						],
						'disableRevertButton' => true,
					],

					'store_notice_position' => [
						'type' => 'ct-radio',
						'label' => __( 'Notice Position', 'noorgfx' ),
						'value' => 'bottom',
						'view' => 'text',
						// 'disableRevertButton' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'top' => __('Top', 'noorgfx'),
							'bottom' => __('Bottom', 'noorgfx'),
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'wooNoticeContent' => [
						'label' => __( 'Notice Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'top',
						'skipEditPalette' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],
						],
					],

					'wooNoticeBackground' => [
						'label' => __( 'Notice Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'skipEditPalette' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'var(--theme-palette-color-1)',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],
						],
					],

				],
			],

		],
	],

];