<?php
/**
 * Star rating options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	noorgfx_rand_md5() => [
		'label' => __('Star Rating', 'noorgfx'),
		'type' => 'ct-panel',
		'setting' => ['transport' => 'postMessage'],
		'inner-options' => [

			'starRatingColor' => [
				'label' => __( 'Star Rating Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'inactive' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Active', 'noorgfx' ),
						'id' => 'default',
						'inherit' => '#FDA256'
					],

					[
						'title' => __( 'Inactive', 'noorgfx' ),
						'id' => 'inactive',
						'inherit' => '#F9DFCC'
					],
				],
			],

		],
	],

];