<?php
/**
 * Product badges options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	noorgfx_rand_md5() => [
		'label' => __('Product Badges', 'noorgfx'),
		'type' => 'ct-panel',
		'setting' => ['transport' => 'postMessage'],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					[
						'sale_badge_shape' => [
							'label' => __( 'Badge Shape', 'noorgfx' ),
							'type' => 'ct-image-picker',
							'value' => 'type-2',
							'attr' => [
								'data-type' => 'background',
								'data-columns' => '3',
							],
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [

								'type-1' => [
									'src'   => noorgfx_image_picker_file( 'badge-1' ),
									'title' => __( 'Type 1', 'noorgfx' ),
								],

								'type-2' => [
									'src'   => noorgfx_image_picker_file( 'badge-2' ),
									'title' => __( 'Type 2', 'noorgfx' ),
								],

								'type-3' => [
									'src'   => noorgfx_image_picker_file( 'badge-3' ),
									'title' => __( 'Type 3', 'noorgfx' ),
								],
							],
						],

						'has_sale_badge' => [
							'label' => __( 'Show Sale Badge', 'noorgfx' ),
							'type' => 'ct-checkboxes',
							'design' => 'block',
							'view' => 'text',
							'allow_empty' => true,
							'value' => [
								'archive' => true,
								'single' => true,
							],
							'divider' => 'top:full',
							'choices' => noorgfx_ordered_keys([
								'archive' => __( 'Archive', 'noorgfx' ),
								'single' => __( 'Single', 'noorgfx' ),
							]),
							'sync' => noorgfx_sync_whole_page([
								// 'prefix' => 'product',
								'loader_selector' => '[data-products] > li, .woocommerce-product-gallery'
							])
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'any' => [
									'has_sale_badge/archive' => true,
									'has_sale_badge/single' => true,
								]
							],
							'options' => [
								'sale_badge_value' => [
									'type' => 'ct-radio',
									'label' => __( 'Sale Badge Value', 'noorgfx' ),
									'value' => 'default',
									'view' => 'text',
									'design' => 'block',
									'setting' => [ 'transport' => 'postMessage' ],
									'choices' => [
										'default' => __( 'Default', 'noorgfx' ),
										'custom' => __( 'Custom', 'noorgfx' ),
									],
									'sync' => noorgfx_sync_whole_page([
										'prefix' => 'woo_categories',
										'loader_selector' => '.onsale'
									]),
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [ 'sale_badge_value' => 'default' ],
									'options' => [
										'sale_badge_default_value' => [
											'label' => __( 'Badge Label', 'noorgfx' ),
											'type' => 'text',
											'design' => 'block',
											'value' => 'SALE',
											'setting' => [ 'transport' => 'postMessage' ],
										],
									],
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [ 'sale_badge_value' => 'custom' ],
									'options' => [
										'sale_badge_custom_value' => [
											'label' => __( 'Badge Label', 'noorgfx' ),
											'type' => 'text',
											'design' => 'block',
											'value' => '-{value}%',
											'sync' => noorgfx_sync_whole_page([
												'prefix' => 'woo_categories',
												'loader_selector' => '.onsale'
											]),
										],
									],
								],
							],
						],

						'has_stock_badge' => [
							'label' => __( 'Show Stock Badge', 'noorgfx' ),
							'type' => 'ct-checkboxes',
							'design' => 'block',
							'view' => 'text',
							'allow_empty' => true,
							'value' => [
								'archive' => true,
								'single' => true,
							],
							'divider' => 'top:full',
							'choices' => noorgfx_ordered_keys([
								'archive' => __( 'Archive', 'noorgfx' ),
								'single' => __( 'Single', 'noorgfx' ),
							]),
							'sync' => noorgfx_sync_whole_page([
								'prefix' => 'woo_categories',
								'loader_selector' => '.out-of-stock-badge'
							])
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'any' => [
									'has_stock_badge/archive' => true,
									'has_stock_badge/single' => true,
								]
							],
							'options' => [
								'stock_badge_value' => [
									'label' => __( 'Badge Label', 'noorgfx' ),
									'type' => 'text',
									'design' => 'block',
									'value' => __('SOLD OUT', 'noorgfx'),
									'setting' => [ 'transport' => 'postMessage' ],
								]
							],
						],
					],

					apply_filters(
						'noorgfx_customizer_options:woocommerce:general:badges:options',
						[]
					)

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					[
						'product_badge_font' => [
							'type' => 'ct-typography',
							'label' => __( 'Font', 'noorgfx' ),
							'value' => noorgfx_typography_default_values([
								'size' => '12px',
								'variation' => 'n6',
								'line-height' => '1.1'
							]),
							'setting' => [ 'transport' => 'postMessage' ],
						],
				
						'saleBadgeColor' => [
							'label' => __( 'Sale Badge', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'text' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'background' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Text', 'noorgfx' ),
									'id' => 'text',
									'inherit' => '#ffffff'
								],

								[
									'title' => __( 'Background', 'noorgfx' ),
									'id' => 'background',
									'inherit' => 'var(--theme-palette-color-1)'
								],
							],
						],

						'outOfStockBadgeColor' => [
							'label' => __( 'Out of Stock Badge', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],

							'value' => [
								'text' => [
									'color' => '#ffffff',
								],

								'background' => [
									'color' => '#24292E',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Text', 'noorgfx' ),
									'id' => 'text',
								],

								[
									'title' => __( 'Background', 'noorgfx' ),
									'id' => 'background',
								],
							],
						],
					],

					apply_filters(
						'noorgfx_customizer_options:woocommerce:general:badges:design:options',
						[]
					)
				],
			],

		],
	],

];