<?php

$card_additional_actions = apply_filters(
	'noorgfx_woo_card_options:additional_actions',
	[
		// ['id' => '...', 'label' => '...']
	]
);

$card_additional_actions_design_options = [];
$card_actions_condition = [];

$card_additional_actions_options = apply_filters(
	'noorgfx_woo_card_options:additional_options',
	[
		[
			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'shop_cards_type' => 'type-3'
				],
				'options' => [
					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'label' => __( 'Additional Actions', 'noorgfx' ),
					]
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'shop_cards_type' => '!type-3'
				],
				'options' => ! empty($card_additional_actions) ? [
					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'label' => __( 'Additional Actions', 'noorgfx' ),
					]
				] : []
			]
		]
	]
);

if (! empty($card_additional_actions)) {
	foreach ($card_additional_actions as $single_action) {
		$card_actions_condition[$single_action['id']] = 'yes';

		$card_additional_actions_options[$single_action['id']] = [
			'label' => $single_action['label'],
			'type' => 'ct-switch',
			'value' => 'yes',
			'sync' => noorgfx_sync_whole_page([
				'loader_selector' => '[data-products]'
			]),
		];
	}
}

$card_additional_actions_design_options[noorgfx_rand_md5()] = [
	'type' => 'ct-condition',
	'condition' => [
		'any' => [
			'all' => [
				'has_archive_add_to_cart' => 'yes',
				'shop_cards_type' => 'type-3'
			],
			'any' => $card_actions_condition,
		]
	],
	'options' => [
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Additional Actions', 'noorgfx' ),
		],

		'additional_actions_button_icon_color' => [
			'label' => __( 'Icon Color', 'noorgfx' ),
			'type'  => 'ct-color-picker',
			'design' => 'block:right',
			'responsive' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'value' => [
				'default' => [
					'color' => 'var(--theme-text-color)',
				],
				'hover' => [
					'color' => '#ffffff',
				],

				'default_2' => [
					'color' => 'var(--theme-text-color)',
				],
				'hover_2' => [
					'color' => 'var(--theme-palette-color-1)',
				],
			],

			'pickers' => [
				[
					'title' => __( 'Initial', 'noorgfx' ),
					'id' => 'default',
					'condition' => [ 'shop_cards_type' => 'type-1|type-2' ]
				],
				[
					'title' => __( 'Hover/Active', 'noorgfx' ),
					'id' => 'hover',
					'condition' => [ 'shop_cards_type' => 'type-1|type-2' ]
				],

				[
					'title' => __( 'Initial', 'noorgfx' ),
					'id' => 'default_2',
					'condition' => [ 'shop_cards_type' => 'type-3' ]
				],
				[
					'title' => __( 'Hover/Active', 'noorgfx' ),
					'id' => 'hover_2',
					'condition' => [ 'shop_cards_type' => 'type-3' ]
				],
			],
		],

		'additional_actions_button_background_color' => [
			'label' => __( 'Background Color', 'noorgfx' ),
			'type'  => 'ct-color-picker',
			'design' => 'block:right',
			'responsive' => true,
			'setting' => [ 'transport' => 'postMessage' ],
			'value' => [
				'default' => [
					'color' => '#ffffff',
				],
				'hover' => [
					'color' => 'var(--theme-palette-color-1)',
				],

				'default_2' => [
					'color' => '#ffffff',
				],
				'hover_2' => [
					'color' => '#ffffff',
				],
			],

			'pickers' => [
				[
					'title' => __( 'Initial', 'noorgfx' ),
					'id' => 'default',
					'condition' => [ 'shop_cards_type' => 'type-1|type-2' ]
				],
				[
					'title' => __( 'Hover/Active', 'noorgfx' ),
					'id' => 'hover',
					'condition' => [ 'shop_cards_type' => 'type-1|type-2' ]
				],

				[
					'title' => __( 'Initial', 'noorgfx' ),
					'id' => 'default_2',
					'condition' => [ 'shop_cards_type' => 'type-3' ]
				],
				[
					'title' => __( 'Hover/Active', 'noorgfx' ),
					'id' => 'hover_2',
					'condition' => [ 'shop_cards_type' => 'type-3' ]
				],
			],
		],
	]
];

$taxonomies = array_values(array_diff(
	get_object_taxonomies('product'),
	[
		'post_format',
		'product_shipping_class',
	]
));

$taxonomies_options = [];

foreach ($taxonomies as $taxonomy) {
	$taxonomy_object = get_taxonomy($taxonomy);

	if (! $taxonomy_object->public) {
		continue;
	}

	$taxonomies_options[$taxonomy] = ucfirst(
		str_replace(
			'Product ',
			'',
			$taxonomy_object->label
		)
	);
}

$options = [
	'product_card_options_panel' => [
		'label' => __( 'Card Options', 'noorgfx' ),
		'type' => 'ct-panel',
		'wrapperAttr' => [ 'data-panel' => 'only-arrow' ],
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [
					'woocommerce_archive_thumbnail_image_width' => [
						'type' => 'hidden',
						'label' => __('Image Width', 'noorgfx'),
						'desc' => __('Image height will be automatically calculated based on the image ratio.', 'noorgfx'),
						'value' => 500,
						'design' => 'inline',
						'setting' => [
							'type' => 'option',
							'capability' => 'manage_woocommerce',
							'transport' => 'postMessage'
						]
					],

					'woocommerce_archive_thumbnail_cropping' => [
						'label' => false,
						'type' => 'hidden',
						'value' => '1:1',
						'setting' => [
							'type' => 'option',
							'capability' => 'manage_woocommerce',
							'transport' => 'postMessage'
						],
						'disableRevertButton' => true,
						'desc' => __('Width', 'noorgfx'),
					],

					'woocommerce_archive_thumbnail_cropping_custom_width' => [
						'label' => false,
						'type' => 'hidden',
						'value' => 3,
						'setting' => [
							'type' => 'option',
							'capability' => 'manage_woocommerce',
							'transport' => 'postMessage'
						],
						'disableRevertButton' => true,
						'desc' => __('Width', 'noorgfx'),
					],

					'woocommerce_archive_thumbnail_cropping_custom_height' => [
						'label' => false,
						'type' => 'hidden',
						'value' => 4,
						'setting' => [
							'type' => 'option',
							'capability' => 'manage_woocommerce',
							'transport' => 'postMessage'
						],
						'disableRevertButton' => true,
						'desc' => __('Height', 'noorgfx'),
					],

					[
						'woo_card_layout' => [
							'label' => false,
							'type' => 'ct-layers',
							'manageable' => false,
							'divider' => 'bottom:full',
							'sync' => [
								noorgfx_sync_whole_page([
									'prefix' => 'woo_categories',
									'loader_selector' => '[data-products] > li'
								]),

								noorgfx_sync_whole_page([
									'id' => 'woo_card_layout_meta',
									'prefix' => 'woo_categories',
									'loader_selector' => '[data-products] > li .entry-meta'
								]),

								[
									'prefix' => 'woo_categories',
									'id' => 'woo_card_layout_skip',
									'loader_selector' => 'skip',
									'container_inclusive' => false
								],
							],
							'value' => noorgfx_get_woo_archive_layout_defaults(),
							'settings' => apply_filters(
								'noorgfx_woo_card_options_layers:extra',
								[
									'product_image' => [
										'label' => __('Product Image', 'noorgfx'),
										'options' => [

											[
												'noorgfx_woocommerce_archive_thumbnail_cropping' => [
													'label' => __('Image Ratio', 'noorgfx'),
													'type' => 'ct-woocommerce-ratio',
													/**
													 * Can be
													 * 1:1
													 * custom
													 * predefined
													 */
													'value' => 'predefined',
													'view' => 'inline',
													'design' => 'block',
													'preview_width_key' => 'woocommerce_archive_thumbnail_image_width',
													'inner-options' => [

														'woocommerce_archive_thumbnail_image_width' => [
															'label' => __('Image Size', 'noorgfx'),
															'type' => 'text',
															'value' => 500,
															'design' => 'block',
															'setting' => [
																'type' => 'option',
																'capability' => 'manage_woocommerce',
															],
															'desc' => __('Image height will be automatically calculated based on the image ratio.', 'noorgfx'),
														],

													],

													'sync' => [
														'id' => 'woo_card_layout_skip'
													]
												],

												'product_image_hover' => [
													'label' => __( 'Hover Effect', 'noorgfx' ),
													'type' => 'ct-select',
													'value' => 'none',
													'view' => 'text',
													'design' => 'block',
													'setting' => [ 'transport' => 'postMessage' ],
													'choices' => noorgfx_ordered_keys(
														[
															'none' => __( 'None', 'noorgfx' ),
															'swap' => __( 'Swap Images', 'noorgfx' ),
															'zoom-in' => __( 'Zoom In', 'noorgfx' ),
															'zoom-out' => __( 'Zoom Out', 'noorgfx' ),
														]
													),

													'sync' => noorgfx_sync_whole_page([
														'prefix' => 'woo_categories',
														'loader_selector' => '[data-products] > li'
													]),
												],
											],

											(
												function_exists('blc_site_has_feature')
												&&
												blc_site_has_feature('base_pro')
											) ? [
												'has_archive_video_thumbnail' => [
													'label' => __( 'Video Thumbnail', 'noorgfx' ),
													'type' => 'ct-switch',
													'value' => 'no',
													'sync' => noorgfx_sync_whole_page([
														'prefix' => 'woo_categories',
														'loader_selector' => '[data-products] > li'
													]),
												],
											] : [],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 25,
												'responsive' => true,

												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],

										],
									],

									'product_title' => [
										'label' => __('Title', 'noorgfx'),
										'options' => [
											'heading_tag' => [
												'label' => __('Heading Tag', 'noorgfx'),
												'type' => 'ct-select',
												'value' => 'h2',
												'view' => 'text',
												'design' => 'block',
												'choices' => noorgfx_ordered_keys(
													[
														'h1' => 'H1',
														'h2' => 'H2',
														'h3' => 'H3',
														'h4' => 'H4',
														'h5' => 'H5',
														'h6' => 'H6',
														'p' => 'p',
														'span' => 'span',
													]
												),
											],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 10,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],
										]
									],

									'product_price' => [
										'label' => __('Price', 'noorgfx'),
										'condition' => [
											'shop_cards_type' => '!type-2'
										],
										'options' => [
											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 10,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],
										]
									],

									'product_rating' => [
										'label' => __('Star Rating', 'noorgfx'),
										'options' => [
											'review_count' => [
												'label' => __( 'Reviews Count', 'noorgfx' ),
												'type' => 'ct-switch',
												'value' => 'no',
												'setting' => [ 'transport' => 'postMessage' ],
											],

											'average_rating' => [
												'label' => __( 'Average Rating', 'noorgfx' ),
												'type' => 'ct-switch',
												'value' => 'no',
												'setting' => [ 'transport' => 'postMessage' ],
											],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 10,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],
										]
									],

									'product_meta' => [
										'label' => __('Taxonomies', 'noorgfx'),
										'clone' => 4,
										'options' => [

											'taxonomy' => [
												'label' => __( 'Taxonomy Source', 'noorgfx' ),
												'type' => 'ct-select',
												'design' => 'block',
												'setting' => [ 'transport' => 'postMessage' ],
												'view' => 'text',
												'choices' => noorgfx_ordered_keys($taxonomies_options),
												'value' => noorgfx_maybe_get_matching_taxonomy('product'),
												'sync' => [
													'id' => 'woo_card_layout_meta'
												]
											],

											'style' => [
												'label' => __( 'Style', 'noorgfx' ),
												'type' => 'ct-select',
												'value' => 'simple',
												'design' => 'block',
												'view' => 'text',
												'choices' => noorgfx_ordered_keys(
													[
														'simple' => __( 'Default', 'noorgfx' ),
														'pill' => __( 'Button', 'noorgfx' ),
														'underline' => __( 'Underline', 'noorgfx' ),
													]
												),
												'sync' => [
													'id' => 'woo_card_layout_meta'
												]
											],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 10,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],

										],
									],

									'product_desc' => [
										'label' => __('Short Description', 'noorgfx'),
										'options' => [
											'excerpt_source' => [
												'label' => false,
												'type' => 'ct-radio',
												'value' => 'excerpt',
												'view' => 'text',
												'choices' => [
													'excerpt' => __('Default', 'noorgfx'),
													'full' => __('Full', 'noorgfx'),
												],
											],

											noorgfx_rand_md5() => [
												'type' => 'ct-condition',
												'condition' => [ 'excerpt_source' => 'excerpt' ],
												'options' => [

													'excerpt_length' => [
														'label' => __('Length', 'noorgfx'),
														'type' => 'ct-number',
														'design' => 'inline',
														'value' => 40,
														'min' => 1,
														'max' => 300,
													],

												],
											],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 25,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],
										]
									],

									'product_add_to_cart' => [
										'label' => __('Add to Cart', 'noorgfx'),
										'condition' => [
											'shop_cards_type' => 'type-1'
										],
										'options' => [

											'auto_hide_button' => [
												'label' => __( 'Auto Hide', 'noorgfx' ),
												'type' => 'ct-switch',
												'value' => 'yes',
												'setting' => [ 'transport' => 'postMessage' ],
												'desc' => __( 'Automatically hide "Add to cart" button after adding the product to cart.', 'noorgfx' ),
											],

											'button_equal_alignment' => [
												'label' => __( 'Equal Alignment', 'noorgfx' ),
												'type' => 'ct-switch',
												'value' => 'yes',
												'setting' => [ 'transport' => 'postMessage' ],
												'desc' => __( 'Align all buttons on the same line, when positioned as the last element.', 'noorgfx' ),
											],

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 0,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],

										],
									],

									'product_add_to_cart_and_price' => [
										'label' => __('Add to Cart and Price', 'noorgfx'),
										'condition' => [
											'shop_cards_type' => 'type-2'
										],
										'options' => [

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 0,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],

										],
									],

									'product_stock' => [
										'label' => __('Stock Information', 'noorgfx'),
										'options' => [

											'spacing' => [
												'label' => __( 'Bottom Spacing', 'noorgfx' ),
												'type' => 'ct-slider',
												'min' => 0,
												'max' => 100,
												'value' => 10,
												'responsive' => true,
												'sync' => [
													'id' => 'woo_card_layout_skip'
												]
											],

										],
									],
								]
							),
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'shop_cards_type' => '!type-2' ],
							'options' => [

								'shop_cards_alignment' => [
									'type' => 'ct-radio',
									'label' => __( 'Content Alignment', 'noorgfx' ),
									'view' => 'text',
									'design' => 'block',
									'divider' => 'bottom',
									'responsive' => true,
									'attr' => [ 'data-type' => 'alignment' ],
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => 'CT_CSS_SKIP_RULE',
									'choices' => [
										'flex-start' => '',
										'center' => '',
										'flex-end' => '',
									],
								],
							],
						],

						'shopCardsGap' => [
							'label' => __( 'Columns Gap', 'noorgfx' ),
							'type' => 'ct-slider',
							'value' => '30px',
							'units' => [
								['unit' => 'px', 'min' => 0, 'max' => 100],
								['unit' => 'em', 'min' => 0, 'max' => 100],
								['unit' => 'rem', 'min' => 0, 'max' => 100],
								['unit' => 'vw', 'min' => 0, 'max' => 100],
								['unit' => 'vh', 'min' => 0, 'max' => 100],
								['unit' => '', 'type' => 'custom'],
							],
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'shopCardsRowGap' => [
							'label' => __( 'Rows Gap', 'noorgfx' ),
							'type' => 'ct-slider',
							'value' => '30px',
							'units' => [
								['unit' => 'px', 'min' => 0, 'max' => 100],
								['unit' => 'em', 'min' => 0, 'max' => 100],
								['unit' => 'rem', 'min' => 0, 'max' => 100],
								['unit' => 'vw', 'min' => 0, 'max' => 100],
								['unit' => 'vh', 'min' => 0, 'max' => 100],
								['unit' => '', 'type' => 'custom'],
							],
							'responsive' => true,
							'setting' => [ 'transport' => 'postMessage' ],
						],
					],

					$card_additional_actions_options,

					apply_filters(
						'noorgfx_woo_card_options_elements:after',
						[]
					)
				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_title:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Title', 'noorgfx' ),
								],

								'cardProductTitleFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([
										'size' => '17px',
										'variation' => 'n6',
									]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'cardProductTitleColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => [
												'var(--theme-heading-1-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h1'
												],

												'var(--theme-heading-2-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h2'
												],

												'var(--theme-heading-3-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h3'
												],

												'var(--theme-heading-4-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h4'
												],

												'var(--theme-heading-5-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h5'
												],

												'var(--theme-heading-6-color, var(--theme-headings-color))' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'h6'
												],

												'var(--theme-text-color)' => [
													'woo_card_layout:array-ids:product_title:heading_tag' => 'span|p'
												],
											]
										],

										[
											'title' => __( 'Hover', 'noorgfx' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-link-hover-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_desc:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Short Description', 'noorgfx' ),
								],

								'cardProductExcerptFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'cardProductExcerptColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_price:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Price', 'noorgfx' ),
								],

								'cardProductPriceFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([
										'variation' => 'n6',
									]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'cardProductPriceColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_meta:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Taxonomies', 'noorgfx' ),
								],

								'card_product_categories_font' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'sync' => 'live',
									'value' => noorgfx_typography_default_values([
										'size' => [
											'desktop' => '12px',
											'tablet'  => '12px',
											'mobile'  => '12px'
										],
										'variation' => 'n6',
										'text-transform' => 'uppercase',
									]),
								],

								'cardProductCategoriesColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => 'var(--theme-text-color)',
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
										],

										[
											'title' => __( 'Hover', 'noorgfx' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-link-hover-color)'
										],
									],
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-has-meta-category-button',
									'optionId' => 'woo_card_layout',
									'options' => [

										'card_product_categories_button_type_font_colors' => [
											'label' => __( 'Button Font Color', 'noorgfx' ),
											'type'  => 'ct-color-picker',
											'design' => 'block:right',
											'divider' => 'top',
											'responsive' => true,
											'noColor' => [ 'background' => 'var(--theme-text-color)'],
											'sync' => 'live',
											'value' => [
												'default' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],

												'hover' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],
											],

											'pickers' => [
												[
													'title' => __( 'Initial', 'noorgfx' ),
													'id' => 'default',
													'inherit' => 'var(--theme-button-text-initial-color)'
												],

												[
													'title' => __( 'Hover', 'noorgfx' ),
													'id' => 'hover',
													'inherit' => 'var(--theme-button-text-hover-color)'
												],
											],
										],

										'card_product_categories_button_type_background_colors' => [
											'label' => __( 'Button Background', 'noorgfx' ),
											'type'  => 'ct-color-picker',
											'design' => 'block:right',
											'responsive' => true,
											'noColor' => [ 'background' => 'var(--theme-text-color)'],
											'sync' => 'live',
											'value' => [
												'default' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],

												'hover' => [
													'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
												],
											],

											'pickers' => [
												[
													'title' => __( 'Initial', 'noorgfx' ),
													'id' => 'default',
													'inherit' => 'var(--theme-button-background-initial-color)'
												],

												[
													'title' => __( 'Hover', 'noorgfx' ),
													'id' => 'hover',
													'inherit' => 'var(--theme-button-background-hover-color)'
												],
											],
										],

									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_sku:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'SKU', 'noorgfx' ),
								],

								'cardProductSkuFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'cardProductSkuColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'shop_cards_type' => 'type-1',
								'woo_card_layout:array-ids:product_add_to_cart:enabled' => '!no'
							],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Add to Cart Button', 'noorgfx' ),
								],

								'cardProductButton1Text' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-button-text-initial-color)'
										],

										[
											'title' => __( 'Hover', 'noorgfx' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-button-text-hover-color)'
										],
									],
								],

								'cardProductButtonBackground' => [
									'label' => __( 'Background Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],

										'hover' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-button-background-initial-color)'
										],

										[
											'title' => __( 'Hover', 'noorgfx' ),
											'id' => 'hover',
											'inherit' => 'var(--theme-button-background-hover-color)'
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'shop_cards_type' => 'type-2',
								'woo_card_layout:array-ids:product_add_to_cart_and_price:enabled' => '!no'
							],
							'options' => [

								'cardProductButton2Text' => [
									'label' => __( 'Button Text Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'divider' => 'top:full',
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => 'var(--theme-text-color)',
										],

										'hover' => [
											'color' => 'var(--theme-link-hover-color)',
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
										],

										[
											'title' => __( 'Hover', 'noorgfx' ),
											'id' => 'hover',
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_card_layout:array-ids:product_stock:enabled' => '!no' ],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-title',
									'label' => __( 'Stock Information', 'noorgfx' ),
								],

								'cardProductStockFont' => [
									'type' => 'ct-typography',
									'label' => __( 'Font', 'noorgfx' ),
									'value' => noorgfx_typography_default_values([
										'size' => '15px',
									]),
									'setting' => [ 'transport' => 'postMessage' ],
								],

								'cardProductStockColor' => [
									'label' => __( 'Font Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],

									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-text-color)'
										],
									],
								],

							],
						],
					],

					$card_additional_actions_design_options,

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'shop_cards_type' => 'type-2' ],
							'options' => [

								'cardProductBackground' => [
									'label' => __( 'Card Background Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'block:right',
									'divider' => 'bottom',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
											'inherit' => 'var(--theme-palette-color-8)'
										],
									],
								],

								'cardProductShadow' => [
									'label' => __( 'Card Shadow', 'noorgfx' ),
									'type' => 'ct-box-shadow',
									'responsive' => true,
									'divider' => 'bottom',
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => noorgfx_box_shadow_value([
										'enable' => true,
										'h_offset' => 0,
										'v_offset' => 12,
										'blur' => 18,
										'spread' => -6,
										'inset' => false,
										'color' => [
											'color' => 'rgba(34, 56, 101, 0.03)',
										],
									])
								],

								'cardProductBorder' => [
									'label' => __( 'Card Border', 'noorgfx' ),
									'type' => 'ct-border',
									'design' => 'block',
									'sync' => 'live',
									'divider' => 'bottom',
									'responsive' => true,
									'value' => [
										'width' => 1,
										'style' => 'none',
										'color' => [
											'color' => 'rgba(0, 0, 0, 0.05)',
										],
									]
								],

							],
						],

						'cardProductRadius' => [
							'label' => [
								__('Image Border Radius', 'noorgfx') => [
									'shop_cards_type' => 'type-1'
								],

								__('Card Border Radius', 'noorgfx') => [
									'shop_cards_type' => 'type-2'
								]
							],
							'type' => 'ct-spacing',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => noorgfx_spacing_value(),
							'inputAttr' => [
								'placeholder' => '3'
							],
							'min' => 0,
							'responsive' => true
						],
					]
				],
			],

		],
	],
];

