<?php

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => 'woo_categories',
	'is_woo' => true,
	'location_name' => __('Product Archives', 'noorgfx'),
]);

$options = [
	'woo_categories_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [
			noorgfx_manager()->get_prefix_title_actions([
				'prefix' => 'woo_categories',
				'areas' => [
					[
						'title' => __('Page Title', 'noorgfx'),
						'options' => $page_title_options,
						'sources' => array_merge(
							noorgfx_manager()
								->screen
								->get_archive_prefixes_with_human_labels([
									'has_categories' => true,
									'has_author' => true,
									'has_search' => true,
									'has_woocommerce' => true,
								]),

								noorgfx_manager()
									->screen
									->get_single_prefixes_with_human_labels([
										'has_woocommerce' => true,
									])
						)
					]
				]
			]),

			$page_title_options,

			[
				noorgfx_rand_md5() => [
					'type' => 'ct-title',
					'label' => __( 'Shop Settings', 'noorgfx' ),
				],

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx' ),
					'type' => 'tab',
					'options' => [

						[
							'shop_cards_type' => [
								'label' => false,
								'type' => 'ct-image-picker',
								'value' => 'type-1',
								'divider' => 'bottom',
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' =>
								apply_filters(
									'noorgfx:options:woocommerce:archive:card-type:choices',
									[
										'type-1' => [
											'src'   => noorgfx_image_picker_url( 'woo-type-1.svg' ),
											'title' => __( 'Type 1', 'noorgfx' ),
										],

										'type-2' => [
											'src'   => noorgfx_image_picker_url( 'woo-type-2.svg' ),
											'title' => __( 'Type 2', 'noorgfx' ),
										],
									]
								),

								'sync' => noorgfx_sync_whole_page([
									'prefix' => 'woo_categories',
									'loader_selector' => '.products > li'
								]),
							],

							'noorgfx_woo_columns' => [
								'label' => __('Columns & Rows', 'noorgfx'),
								'type' => 'ct-woocommerce-columns-and-rows',
								'value' => [
									'desktop' => 4,
									'tablet' => 3,
									'mobile' => 1,
									'__changed' => ['tablet', 'mobile']
								],
								'min' => 1,
								'max' => 6,
								'responsive' => true,
								'setting' => [
									'transport' => 'postMessage'
								],
							],

							'woocommerce_catalog_columns' => [
								'type' => 'hidden',
								'value' => 4,
								'setting' => [
									'type' => 'option',
									'transport' => 'postMessage'
								],
							],

							'woocommerce_catalog_rows' => [
								'type' => 'hidden',
								'value' => 4,
								'setting' => [
									'type' => 'option',
								],

								'sync' => noorgfx_sync_whole_page([
									'prefix' => 'woo_categories',
									'loader_selector' => '.products > li'
								]),
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-divider',
								'attr' => [ 'data-type' => 'small' ]
							],
						],

						noorgfx_get_options('woocommerce/card-product-elements'),

						'woo_categories_content_area_spacing' => [
							'label' => __( 'Content Area Vertical Spacing', 'noorgfx' ),
							'type' => 'ct-radio',
							'value' => 'both',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top:full',
							'attr' => [ 'data-type' => 'content-spacing' ],
							'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
							'sync' => "live",
							'choices' => [
								'both'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx' ) . '</i>',

								'top'    => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx' ) . '</i>',

								'bottom' => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx' ) . '</i>',

								'none'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx' ) . '</i>',
							],
							'desc' => noorgfx_safe_sprintf(
								// translators: placeholder here means the actual URL.
								__( 'You can customize the global spacing value in General ➝ Layout ➝ %sContent Area Spacing%s.', 'noorgfx' ),
								noorgfx_safe_sprintf(
									'<a data-trigger-section="general:layout_panel" href="%s">',
									admin_url('/customize.php?autofocus[section]=general&ct_autofocus=general:layout_panel')
								),
								'</a>'
							),
						],

					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx' ),
					'type' => 'tab',
					'options' => [
						'shop_archive_background' => [
							'label' => __('Page Background', 'noorgfx'),
							'type' => 'ct-background',
							'design' => 'block:right',
							'responsive' => true,
							'sync' => 'live',
							'divider' => 'bottom',
							'value' => noorgfx_background_default_value([
								'backgroundColor' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
									],
								],
							]),
							'desc' => noorgfx_safe_sprintf(
								// translators: placeholder here means the actual URL.
								__( 'Please note, by default this option is inherited from Colors ➝ %sSite Background%s.', 'noorgfx' ),
								noorgfx_safe_sprintf(
									'<a data-trigger-section="color" href="%s">',
									admin_url('/customize.php?autofocus[section]=color')
								),
								'</a>'
							),
						],
					],
				],

				noorgfx_rand_md5() => [
					'type'  => 'ct-title',
					'label' => __( 'Page Elements', 'noorgfx' ),
				],
			],

			apply_filters(
				'noorgfx:options:woocommerce:archive:filters-canvas',
				[]
			),

			apply_filters(
				'noorgfx:options:woocommerce:archive:active-filters',
				[]
			),

			noorgfx_get_options('woocommerce/results-count'),

			noorgfx_get_options('woocommerce/products-sorting'),

			noorgfx_get_options('general/sidebar-particular', [
				'prefix' => 'woo_categories',
			]),

			noorgfx_get_options('general/pagination', [
				'prefix' => 'woo_categories',
			]),

			[
				noorgfx_rand_md5() => [
					'type'  => 'ct-title',
					'label' => __( 'Functionality Options', 'noorgfx' ),
				],
			],

			apply_filters(
				'noorgfx:options:woocommerce:archive:ajax-filtering',
				[]
			),

			[
				'product_catalog_panel' => [
					'label' => __( 'Product Catalog', 'noorgfx' ),
					'type' => 'ct-panel',
					'wrapperAttr' => [ 'data-panel' => 'only-arrow' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'inner-options' => [

						'woocommerce_shop_page_display' => [
							'label' => __( 'Shop page display', 'noorgfx' ),
							'type' => 'ct-select',
							'value' => '',
							'view' => 'text',
							'placeholder' => __('Show products', 'noorgfx'),
							'design' => 'block',
							'setting' => [
								'type' => 'option'
							],
							'desc' => __( 'Choose what to display on the main shop page.', 'noorgfx' ),
							'choices' => noorgfx_ordered_keys(
								[
									'' => __('Show products', 'noorgfx'),
									'subcategories' => __('Show categories', 'noorgfx'),
									'both' => __('Show categories & products', 'noorgfx'),
								]
							),
						],

						'woocommerce_category_archive_display' => [
							'label' => __( 'Category display', 'noorgfx' ),
							'type' => 'ct-select',
							'value' => '',
							'view' => 'text',
							'placeholder' => __('Show products', 'noorgfx'),
							'design' => 'block',
							'setting' => [
								'type' => 'option'
							],
							'desc' => __( 'Choose what to display on product category pages.', 'noorgfx' ),
							'choices' => noorgfx_ordered_keys(
								[
									'' => __('Show products', 'noorgfx'),
									'subcategories' => __('Show subcategories', 'noorgfx'),
									'both' => __('Show subcategories & products', 'noorgfx'),
								]
							),
						],

						'woocommerce_default_catalog_orderby' => [
							'label' => __( 'Default product sorting', 'noorgfx' ),
							'type' => 'ct-select',
							'value' => 'menu_order',
							'view' => 'text',
							'design' => 'block',
							'desc' => __( 'How should products be sorted in the catalog by default?', 'noorgfx' ),
							'setting' => [
								'type' => 'option'
							],
							'choices' => noorgfx_ordered_keys(
								apply_filters(
									'woocommerce_default_catalog_orderby_options',
									[
										'menu_order' => __('Default sorting (custom ordering + name)', 'noorgfx'),
										'popularity' => __('Popularity (sales)', 'noorgfx'),
										'rating' => __('Average rating', 'noorgfx'),
										'date' => __('Sort by most recent', 'noorgfx'),
										'price' => __('Sort by price (asc)', 'noorgfx'),
										'price-desc' => __('Sort by price (desc)', 'noorgfx'),
									]
								)
							),
						],

					],
				],

			],

		],
	],
];
