<?php

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

if (! isset($enabled)) {
	$enabled = 'no';
}

if (! isset($post_type)) {
	$post_type = 'post';
}

$options = [
	$prefix . 'has_post_nav' => [
		'label' => __( 'Posts Navigation', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => $enabled,
		'sync' => noorgfx_sync_single_post_container([
			'prefix' => $prefix
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'post_nav_criteria' => [
						'label' => __( 'Navigation Criteria', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'default',
						'view' => 'text',
						'design' => 'block',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'default' => __( 'Default', 'noorgfx' ),
							'taxonomy' => __( 'Taxonomy', 'noorgfx' ),
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ $prefix . 'post_nav_criteria' => 'taxonomy' ],
						'options' => [

							$prefix . 'post_nav_taxonomy' => [
								'label' => __( 'Taxonomy', 'noorgfx' ),
								'desc' => __( 'Navigate through posts that are from the same taxonomy.', 'noorgfx' ),
								'type' => 'ct-select',
								'value' => array_keys(noorgfx_get_taxonomies_for_cpt(
									$post_type
								))[0],
								'view' => 'text',
								'design' => 'inline',
								'choices' => noorgfx_ordered_keys(
									noorgfx_get_taxonomies_for_cpt($post_type)
								),
								'sync' => [
									'prefix' => $prefix,
									'selector' => '.post-navigation',
									'render' => function () {
										echo noorgfx_post_navigation();
									}
								]
							],

						],
					],

					$prefix . 'post_nav_spacing' => [
						'label' => __( 'Container Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => '50px',
						'units' => noorgfx_units_config([
							[ 'unit' => 'px', 'min' => 0, 'max' => 200],
							['unit' => '', 'type' => 'custom'],
						]),
						'responsive' => true,
						'sync' => 'live',
						'divider' => 'top:bottom',
					],

					$prefix . 'post_nav_thumb_size' => [
						'label' => __('Image Size', 'noorgfx'),
						'type' => 'ct-select',
						'value' => 'medium',
						'view' => 'text',
						'design' => 'inline',
						'divider' => 'bottom',
						'choices' => noorgfx_ordered_keys(
							noorgfx_get_all_image_sizes()
						),
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.post-navigation',
							'render' => function () {
								echo noorgfx_post_navigation();
							}
						]
					],

					$prefix . 'post_nav_thumb_visibility' => [
						'label' => __( 'Image Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'sync' => 'live',
						'divider' => 'bottom',
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

					$prefix . 'post_nav_title_visibility' => [
						'label' => __( 'Title Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'sync' => 'live',
						'divider' => 'bottom',
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => false,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

					$prefix . 'post_nav_visibility' => [
						'label' => __( 'Module Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'sync' => 'live',
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'posts_nav_font_color' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'sync' => 'live',
						'value' => [
							'default' => [
								'color' => 'var(--theme-text-color)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],
						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					$prefix . 'posts_nav_image_overlay_color' => [
						'label' => __( 'Thumbnail Overlay Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'sync' => 'live',
						'divider' => 'top',
						'value' => [
							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],
						'pickers' => [
							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-1)'
							],
						],
					],

					$prefix . 'posts_nav_image_border_radius' => [
						'label' => __( 'Thumbnail Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => noorgfx_spacing_value(),
						'inputAttr' => [
							'placeholder' => '100'
						],
						'min' => 0,
						'sync' => 'live',
					],

				],
			],

		],
	],

];

