<?php

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

$options = [
	$prefix . 'has_featured_image' => [
		'label' => __( 'Featured Image', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'no',
		'sync' => noorgfx_sync_single_post_container([
			'prefix' => $prefix
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					[

						$prefix . 'featured_image_ratio' => [
							'label' => __( 'Image Ratio', 'noorgfx' ),
							'type' => 'ct-ratio',
							'view' => 'inline',
							'value' => 'original',
							'sync' => 'live',
						],

						$prefix . 'featured_image_size' => [
							'label' => __('Image Size', 'noorgfx'),
							'type' => 'ct-select',
							'value' => 'full',
							'view' => 'text',
							'design' => 'block',
							'divider' => 'top',
							'sync' => noorgfx_sync_single_post_container([
								'prefix' => $prefix
							]),
							'choices' => noorgfx_ordered_keys(noorgfx_get_all_image_sizes())
						],

					],

					(
						function_exists('blc_site_has_feature')
						&&
						blc_site_has_feature('base_pro')
					) ? [
						$prefix . 'video_thumbnail' => [
							'label' => __( 'Video Thumbnail', 'noorgfx' ),
							'type' => 'ct-switch',
							'value' => 'no',
							'divider' => 'top',
							'sync' => noorgfx_sync_single_post_container([
								'prefix' => $prefix
							]),
						]
					] : [],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'structure' => 'type-3 | type-4',
							$prefix . 'content_style' => '~wide',
						],
						'options' => [
							$prefix . 'featured_image_width' => [
								'label' => __( 'Image Width', 'noorgfx' ),
								'type' => 'ct-radio',
								'value' => 'default',
								'view' => 'text',
								'design' => 'block',
								'divider' => 'top',
								'choices' => [
									'default' => __( 'Default', 'noorgfx' ),
									'wide' => __( 'Wide', 'noorgfx' ),
									'full' => __( 'Full', 'noorgfx' ),
								],
								'sync' => 'live'
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'hero_enabled' => 'yes',
							$prefix . 'hero_section' => '!type-2'
						],
						'options' => [
							$prefix . 'featured_image_location' => [
								'label' => __( 'Image Location', 'noorgfx' ),
								'type' => 'ct-radio',
								'value' => 'above',
								'view' => 'text',
								'design' => 'block',
								'divider' => 'top',
								'choices' => [
									'above' => __( 'Above Title', 'noorgfx' ),
									'below' => __( 'Below Title', 'noorgfx' ),
								],
								'sync' => noorgfx_sync_single_post_container([
									'prefix' => $prefix
								]),
							],
						],
					],

					$prefix . 'featured_image_visibility' => [
						'label' => __( 'Image Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top',
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),

						'sync' => 'live'
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'featured_image_border_radius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'sync' => 'live',
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true
					],

				],
			],

		],
	],

];
