<?php

if (! isset($is_general_cpt)) {
    $is_general_cpt = false;
}

if (! isset($is_bbpress)) {
	$is_bbpress = false;
}

$page_title_options = noorgfx_get_options(
	'general/page-title',
	apply_filters(
		'noorgfx:options:cpt:page-title-args',
		[
			'prefix' => $post_type->name . '_single',
			'is_single' => true,
			'is_bbpress' => $is_bbpress,
			'is_cpt' => true,
			'enabled_label' => noorgfx_safe_sprintf(
				__('%s Title', 'noorgfx'),
				$post_type->labels->singular_name
			),

			'location_name' => noorgfx_safe_sprintf(
				__('Single %s', 'noorgfx'),
				$post_type->labels->singular_name
			)
		],
		$post_type->name
	)
);

$page_structure_options = [
	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => noorgfx_safe_sprintf(
			__('%s Structure', 'noorgfx'),
			$post_type->labels->singular_name
		),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => array_merge([
			noorgfx_get_options('single-elements/structure', [
				'prefix' => $post_type->name . '_single',
				'default_structure' => 'type-4',
				'default_content_style' => $is_bbpress ? 'boxed' : 'wide'
			])
		]),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			noorgfx_get_options('single-elements/structure-design', [
				'prefix' => $post_type->name . '_single',
			])
		],
	]
];

$maybe_taxonomy = noorgfx_maybe_get_matching_taxonomy($post_type->name, false);

$areas = [
	[
		'title' => __('Page Title', 'noorgfx'),
		'options' => $page_title_options,
		'sources' => array_merge(
			noorgfx_manager()
				->screen
				->get_archive_prefixes_with_human_labels([
					'has_categories' => true,
					'has_author' => true,
					'has_search' => true,
					'has_woocommerce' => true
				]),

				noorgfx_manager()
					->screen
					->get_single_prefixes_with_human_labels([
						'has_woocommerce' => true
					])
		)
	],

	[
		'id' => 'page_structure',
		'title' => __('Page Structure', 'noorgfx'),
		'options' => $page_structure_options,
		'sources' => noorgfx_manager()
			->screen
			->get_single_prefixes_with_human_labels()
	]
];

$page_elements_options = [];

if ($is_general_cpt) {
	$page_elements_options = [
		apply_filters(
			'noorgfx_single_posts_post_elements_start',
			[],
			$post_type->name . '_single'
		),

		noorgfx_get_options('single-elements/featured-image', [
			'prefix' => $post_type->name . '_single',
		]),

		$maybe_taxonomy ? [
			/*
			$post_type->name . '_single_has_post_tags' => [
				'label' => noorgfx_safe_sprintf(
					__('%s %s', 'noorgfx'),
					$post_type->labels->singular_name,
					get_taxonomy($maybe_taxonomy)->label
				),
				'type' => 'ct-switch',
				'value' => 'no',
				'sync' => noorgfx_sync_single_post_container([
					'prefix' => $post_type->name . '_single'
				]),
			],
			 */

			noorgfx_get_options('single-elements/post-tags', [
				'prefix' => $post_type->name . '_single',
				'post_type' => $post_type->name
			]),
		] : [],

		noorgfx_get_options('single-elements/post-share-box', [
			'prefix' => $post_type->name . '_single',
			'has_share_box' => 'no',
		]),

		noorgfx_get_options('single-elements/author-box', [
			'prefix' => $post_type->name . '_single',
		]),

		noorgfx_get_options('single-elements/post-nav', [
			'prefix' => $post_type->name . '_single',
			'enabled' => 'no',
			'post_type' => $post_type->name
		]),

		apply_filters(
			'noorgfx_single_posts_post_elements_end',
			[],
			$post_type->name . '_single'
		),

		[
			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Page Elements', 'noorgfx' ),
			],
		],

		noorgfx_get_options('single-elements/related-posts', [
			'prefix' => $post_type->name . '_single',
			'enabled' => 'no',
			'post_type' => $post_type->name
		]),

		noorgfx_get_options('general/comments-single', [
			'prefix' => $post_type->name . '_single',
		]),

		apply_filters(
			'noorgfx_single_posts_end_customizer_options',
			[],
			$post_type->name . '_single'
		)
	];

	$areas[] = [
		'title' => __('Page Elements', 'noorgfx'),
		'options' => $page_elements_options,
		'sources' => noorgfx_manager()
			->screen
			->get_single_prefixes_with_human_labels()
	];
}

$inner_options = array_merge(
	[
		noorgfx_manager()->get_prefix_title_actions([
			'prefix' => $post_type->name . '_single',
			'areas' => $areas
		]),

		array_merge(
			$page_title_options,
			$page_structure_options,
			$is_general_cpt ? [
				noorgfx_rand_md5() => [
					'type' => 'ct-title',
					'label' => noorgfx_safe_sprintf(
						__('%s Elements', 'noorgfx'),
						$post_type->labels->singular_name
					),
				],
			] : []
		)
	],

	$page_elements_options
);

if (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'single',
		'template_subtype' => 'canvas',
		'match_conditions_strategy' => $post_type->name . '_single'
	])
) {
	$inner_options = [
		noorgfx_rand_md5() => [
			'type' => 'ct-notification',
			'attr' => [ 'data-type' => 'background:white' ],
			'text' => noorgfx_safe_sprintf(
				__('This single page is overrided by a custom template, to edit it please access %sthis page%s.', 'noorgfx'),
				'<a href="' . get_edit_post_link(blc_get_content_block_that_matches([
					'template_type' => 'single',
					'template_subtype' => 'canvas',
					'match_conditions_strategy' => $post_type->name . '_single'
				])) . '" target="_blank">',
				'</a>'
			)
		],
	];
}

$options = [
	$post_type->name . '_single_section_options' => [
		'type' => 'ct-options',
		'inner-options' => $inner_options
	],
];
