<?php

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => $post_type->name . '_archive',
	'is_cpt' => true,
	'is_archive' => true,
	'enabled_label' => noorgfx_safe_sprintf(
		__('%s Title', 'noorgfx'),
		$post_type->labels->name
	),

	'location_name' => $post_type->labels->name
]);

$posts_listing_options = noorgfx_get_options('general/posts-listing', [
	'prefix' => $post_type->name . '_archive',
	'title' => $post_type->labels->name,
	'is_cpt' => true
]);

$pagination_options = noorgfx_get_options('general/pagination', [
	'prefix' => $post_type->name . '_archive',
]);

$inner_options = [
	noorgfx_manager()->get_prefix_title_actions([
		'prefix' => $post_type->name . '_archive',
		'areas' => [
			[
				'title' => __('Page Title', 'noorgfx'),
				'options' => $page_title_options,
				'sources' => array_merge(
					noorgfx_manager()
						->screen
						->get_archive_prefixes_with_human_labels([
							'has_categories' => true,
							'has_author' => true,
							'has_search' => true,
							'has_woocommerce' => true
						]),

					noorgfx_manager()
						->screen
						->get_single_prefixes_with_human_labels([
							'has_woocommerce' => true
						])
				)
			],

			[
				'id' => 'posts_listing',
				'title' => __('Posts Listing', 'noorgfx'),
				'options' => $posts_listing_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			],

			[
				'title' => __('Pagination', 'noorgfx'),
				'options' => $pagination_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			]
		]
	]),

	$page_title_options,
	$posts_listing_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Page Elements', 'noorgfx' ),
		],
	],

	noorgfx_get_options('general/sidebar-particular', [
		'prefix' => $post_type->name . '_archive',
	]),

	$pagination_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __('Functionality Options', 'noorgfx'),
		],
	],

	apply_filters(
		'noorgfx_posts_home_page_elements_end',
		[],
		$post_type->name . '_archive',
		$post_type->name
	),

	noorgfx_get_options('general/cards-reveal-effect', [
		'prefix' => $post_type->name . '_archive',
	]),
];

$options = [
	$post_type->name . '_post_type_section_options' => [
		'type' => 'ct-options',
		'inner-options' => $inner_options
	],
];
