<?php
/**
 * Blog options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => 'blog',
	'is_home' => true,
	'enabled_label' => __('Blog Title', 'noorgfx'),
	'enabled_default' => 'no',
	'location_name' => __('Blog Posts', 'noorgfx'),
]);

$posts_listing_options = noorgfx_get_options('general/posts-listing', [
	'prefix' => 'blog',
	'title' => __('Blog', 'noorgfx')
]);

$pagination_options = noorgfx_get_options('general/pagination', [
	'prefix' => 'blog',
]);

$inner_options = [
	noorgfx_manager()->get_prefix_title_actions([
		'prefix' => 'blog',
		'areas' => [
			[
				'title' => __('Page Title', 'noorgfx'),
				'options' => $page_title_options,

				'sources' => array_merge(
					noorgfx_manager()
						->screen
						->get_archive_prefixes_with_human_labels([
							'has_categories' => true,
							'has_author' => true,
							'has_search' => true,
							'has_woocommerce' => true
						]),

					noorgfx_manager()
						->screen
						->get_single_prefixes_with_human_labels([
							'has_woocommerce' => true
						])
				)
			],

			[
				'id' => 'posts_listing',
				'title' => __('Posts Listing', 'noorgfx'),
				'options' => $posts_listing_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			],

			[
				'title' => __('Pagination', 'noorgfx'),
				'options' => $pagination_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			]
		]
	]),

	$page_title_options,
	$posts_listing_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Page Elements', 'noorgfx' ),
		],
	],

	noorgfx_get_options('general/sidebar-particular', [
		'prefix' => 'blog',
	]),

	$pagination_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Functionality Options', 'noorgfx' ),
		],
	],

	apply_filters(
		'noorgfx_posts_home_page_elements_end',
		[],
		'blog',
		'post'
	),

	noorgfx_get_options('general/cards-reveal-effect', [
		'prefix' => 'blog',
	]),
];

if (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'archive',
		'template_subtype' => 'canvas',
		'match_conditions_strategy' => 'blog'
	])
) {
	$inner_options = [
		noorgfx_rand_md5() => [
			'type' => 'ct-notification',
			'attr' => [ 'data-type' => 'background:white' ],
			'text' => noorgfx_safe_sprintf(
				__('This archive page is overrided by a custom template, to edit it please access %sthis page%s.', 'noorgfx'),
				'<a href="' . get_edit_post_link(blc_get_content_block_that_matches([
					'template_type' => 'archive',
					'template_subtype' => 'canvas',
					'match_conditions_strategy' => 'blog'
				])) . '" target="_blank">',
				'</a>'
			)
		],
	];
}

$options = [
	'blog_posts_section_options' => [
		'type' => 'ct-options',
		'inner-options' => $inner_options
	],
];
