<?php
/**
 * Search page
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => 'search',
	'is_search' => true,
	'location_name' => __('Search', 'noorgfx')
]);

$posts_listing_options = noorgfx_get_options('general/posts-listing', [
	'prefix' => 'search',
	'title' => __('Search Results', 'noorgfx')
]);

$pagination_options = noorgfx_get_options('general/pagination', [
	'prefix' => 'search',
]);

$inner_options = [
	noorgfx_manager()->get_prefix_title_actions([
		'prefix' => 'search',
		'areas' => [
			[
				'title' => __('Page Title', 'noorgfx'),
				'options' => $page_title_options,
				'sources' => array_merge(
					noorgfx_manager()
						->screen
						->get_archive_prefixes_with_human_labels([
							'has_categories' => true,
							'has_author' => true,
							'has_search' => true,
							'has_woocommerce' => true
						]),

					noorgfx_manager()
						->screen
						->get_single_prefixes_with_human_labels([
							'has_woocommerce' => true
						])
				)
			],

			[
				'id' => 'posts_listing',
				'title' => __('Posts Listing', 'noorgfx'),
				'options' => $posts_listing_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			],

			[
				'title' => __('Pagination', 'noorgfx'),
				'options' => $pagination_options,
				'sources' => noorgfx_manager()
					->screen
					->get_archive_prefixes_with_human_labels([
						'has_categories' => true,
						'has_author' => true,
						'has_search' => true
					]),
			]
		]
	]),

	$page_title_options,
	$posts_listing_options,

	[
		noorgfx_rand_md5() => [
			'type'  => 'ct-title',
			'label' => __( 'Page Elements', 'noorgfx' ),
		],
	],

	noorgfx_get_options('general/sidebar-particular', [
		'prefix' => 'search'
	]),

	$pagination_options,

	[
		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Functionality Options', 'noorgfx' ),
		],

		'search_enable_live_results' => [
			'label' => __( 'Live results', 'noorgfx' ),
			'type' => 'ct-switch',
			'value' => 'yes',
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'search_enable_live_results' => 'yes' ],
			'options' => function_exists('is_shop') ? [

				'searchProductPrice' => [
					'label' => __( 'Live Results Product Price', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
				],

				'searchProductStatus' => [
					'label' => __( 'Live Results Product Status', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
				],

			] : []
		],
	],

	noorgfx_get_options('general/cards-reveal-effect', [
		'prefix' => 'search'
	])
];

if (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'archive',
		'template_subtype' => 'canvas',
		'match_conditions_strategy' => 'search'
	])
) {
	$inner_options = [
		noorgfx_rand_md5() => [
			'type' => 'ct-notification',
			'attr' => [ 'data-type' => 'background:white' ],
			'text' => noorgfx_safe_sprintf(
				__('This archive page is overrided by a custom template, to edit it please access %sthis page%s.', 'noorgfx'),
				'<a href="' . get_edit_post_link(blc_get_content_block_that_matches([
					'template_type' => 'archive',
					'template_subtype' => 'canvas',
					'match_conditions_strategy' => 'search'
				])) . '" target="_blank">',
				'</a>'
			)
		],
	];
}

$options = [
	'search_section_options' => [
		'type' => 'ct-options',
		'inner-options' => $inner_options
	]
];
