<?php

$prefix = 'courses_single_';

$design_options = [
	$prefix . 'hero_title_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Title Font', 'noorgfx' ),
		'value' => noorgfx_typography_default_values([
			'size' => '30px'
		]),
		'design' => 'block',
		'sync' => 'live'
	],

	$prefix . 'hero_title_font_color' => [
		'label' => __( 'Title Font Color', 'noorgfx' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'noorgfx' ),
				'id' => 'default',
				'inherit' => 'var(--theme-heading-1-color, var(--theme-headings-color))'
			],
		],
	],

	$prefix . 'hero_categories_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Categories Font', 'noorgfx' ),
		'value' => noorgfx_typography_default_values([
			'size' => '14px',
			'variation' => 'n5',
			'line-height' => '1.3',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_categories_colors' => [
		'label' => __( 'Categories Font Color', 'noorgfx' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],

			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'noorgfx' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],

			[
				'title' => __( 'Hover', 'noorgfx' ),
				'id' => 'hover',
				'inherit' => 'var(--theme-link-hover-color)'
			],
		],
	],

	$prefix . 'hero_actions_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Course Actions Font', 'noorgfx' ),
		'value' => noorgfx_typography_default_values([
			'size' => '15px',
			'variation' => 'n4',
			'line-height' => '1.4',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_actions_colors' => [
		'label' => __( 'Course Actions Font Color', 'noorgfx' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],

			'hover' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'noorgfx' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],

			[
				'title' => __( 'Hover', 'noorgfx' ),
				'id' => 'hover',
				'inherit' => 'var(--theme-link-hover-color)'
			],
		],
	],

	$prefix . 'hero_title_rating_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Rating Font', 'noorgfx' ),
		'value' => noorgfx_typography_default_values([
			'size' => '14px',
			'variation' => 'n4',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_title_rating_font_color' => [
		'label' => __( 'Rating Font Color', 'noorgfx' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'noorgfx' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],
		],
	],

	$prefix . 'hero_title_star_rating_color' => [
		'label' => __( 'Star Rating Color', 'noorgfx' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'divider' => 'top',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'noorgfx' ),
				'id' => 'default',
				'inherit' => '#ED9700'
			],
		],
	],

];

$options = [
	'tutorlms_course_options' => [
		'type' => 'ct-options',
		'inner-options' => [
			noorgfx_get_options('general/page-title', [
				'prefix' => 'courses_single',
				'is_single' => true,
				'is_cpt' => true,
				'has_hero_elements' => false,
				'enabled_label' => noorgfx_safe_sprintf(
					__('%s Title', 'noorgfx'),
					'Course'
				),
				'design_options' => $design_options,
				'location_name' => __('Course Single', 'noorgfx')
			]),

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Course Structure', 'noorgfx' ),
			],

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [
					noorgfx_get_options('single-elements/structure', [
						'skipped_structure' => ['type-4', 'type-3'],
						'default_structure' => 'type-1',
						'prefix' => 'courses_single',
					]),
				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					noorgfx_get_options('single-elements/structure-design', [
						'prefix' => 'courses_single',
					])

				],
			],

		]
	]
];

