<?php

if (! isset($prefix)) {
	$prefix = '';
	$initial_prefix = '';
} else {
	$initial_prefix = $prefix;
	$prefix = $prefix . '_';
}

$options = [
	$prefix . 'has_pagination' => [
		'label' => __( 'Pagination', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'yes',
		'sync' => noorgfx_sync_whole_page([
			'prefix' => $prefix,
			'loader_selector' => 'section'
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'pagination_global_type' => [
						'label' => __( 'Pagination Type', 'noorgfx' ),
						'type' => 'ct-select',
						'value' => 'simple',
						'view' => 'text',
						'design' => 'inline',
						'choices' => noorgfx_ordered_keys(
							[
								'simple' => __( 'Standard', 'noorgfx' ),
								'next_prev' => __( 'Next/Prev', 'noorgfx' ),
								'load_more' => __( 'Load More', 'noorgfx' ),
								'infinite_scroll' => __( 'Infinite Scroll', 'noorgfx' ),
							]
						),

						'sync' => [
							'selector' => '.ct-pagination',
							'prefix' => $prefix,
							'render' => function ($args) {
								echo noorgfx_display_posts_pagination();
							}
						]
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ $prefix . 'pagination_global_type' => 'load_more' ],
						'options' => [

							$prefix . 'load_more_label' => [
								'label' => __( 'Label', 'noorgfx' ),
								'type' => 'text',
								'design' => 'inline',
								'value' => __( 'Load More', 'noorgfx' ),
								'sync' => 'live',
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ $prefix . 'pagination_global_type' => 'simple' ],
						'options' => [

							$prefix . 'numbers_visibility' => [
								'label' => __( 'Numbers Visibility', 'noorgfx' ),
								'type' => 'ct-visibility',
								'design' => 'block',
								'sync' => 'live',
								'divider' => 'top',
								'value' => noorgfx_default_responsive_value([
									'desktop' => true,
									'tablet' => true,
									'mobile' => false,
								]),
								'choices' => noorgfx_ordered_keys([
									'desktop' => __( 'Desktop', 'noorgfx' ),
									'tablet' => __( 'Tablet', 'noorgfx' ),
									'mobile' => __( 'Mobile', 'noorgfx' ),
								]),
							],

							$prefix . 'arrows_visibility' => [
								'label' => __( 'Arrows Visibility', 'noorgfx' ),
								'type' => 'ct-visibility',
								'design' => 'block',
								'sync' => 'live',
								'divider' => 'top',
								'allow_empty' => true,
								'value' => noorgfx_default_responsive_value([
									'desktop' => true,
									'tablet' => true,
									'mobile' => true,
								]),
								'choices' => noorgfx_ordered_keys([
									'desktop' => __( 'Desktop', 'noorgfx' ),
									'tablet' => __( 'Tablet', 'noorgfx' ),
									'mobile' => __( 'Mobile', 'noorgfx' ),
								]),
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					$prefix . 'paginationSpacing' => [
						'label' => __( 'Pagination Top Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => '60px',
						'units' => noorgfx_units_config([
							[ 'unit' => 'px', 'min' => 0, 'max' => 200 ],
							['unit' => '', 'type' => 'custom'],
						]),
						'responsive' => true,
						'sync' => 'live',
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'pagination_global_type' => 'simple|next_prev'
						],
						'options' => [

							$prefix . 'simplePaginationFontColor' => [
								'label' => __( 'Colors', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'active' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],
								'sync' => 'live',

								'pickers' => [
									[
										'title' => __( 'Text Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Text Active', 'noorgfx' ),
										'id' => 'active',
										'inherit' => '#ffffff',
										'condition' => [ $prefix . 'pagination_global_type' => 'simple' ]
									],

									[
										'title' => __( 'Accent', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'pagination_global_type' => 'load_more'
						],
						'options' => [

							$prefix . 'paginationButtonText' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'sync' => 'live',
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-button-text-initial-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-button-text-hover-color)'
									],
								],
							],

							$prefix . 'paginationButton' => [
								'label' => __( 'Button Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'sync' => 'live',
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-button-background-initial-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-button-background-hover-color)'
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'pagination_global_type' => '!infinite_scroll'
						],
						'options' => [

							$prefix . 'paginationDivider' => [
								'label' => __( 'Divider', 'noorgfx' ),
								'type' => 'ct-border',
								'design' => 'inline',
								'divider' => 'top',
								'sync' => 'live',
								'value' => [
									'width' => 1,
									'style' => 'none',
									'color' => [
										'color' => 'rgba(224, 229, 235, 0.5)',
									],
								]
							],

							$prefix . 'pagination_border_radius' => [
								'label' => __( 'Border Radius', 'noorgfx' ),
								'type' => 'ct-spacing',
								'divider' => 'top',
								'value' => noorgfx_spacing_value(),
								'inputAttr' => [
									'placeholder' => '4'
								],
								'min' => 0,
								'sync' => 'live',
							],

						],
					],

				],
			],
		],
	],
];
