<?php
/**
 * Layout options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'layout_panel' => [
		'label' => __( 'Layout', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [

				'maxSiteWidth' => [
					'label' => __( 'Maximum Site Width', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => 1290,
					'min' => 700,
					'max' => 1900,
                    'sync' => 'live',
				],

				'contentAreaSpacing' => [
					'label' => __( 'Content Area Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => [
						'desktop' => '60px',
						'tablet' => '60px',
						'mobile' => '50px',
					],
					'units' => noorgfx_units_config([
						[ 'unit' => 'px', 'min' => 0, 'max' => 300 ],
					]),
					'responsive' => true,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'Adjusts vertical spacing between main content area and header/footer.', 'noorgfx' ),
				],

				'contentEdgeSpacing' => [
					'label' => __( 'Content Edge Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => [
						'desktop' => 5,
						'tablet' => 5,
						'mobile' => 6,
					],
					'min' => 0,
					'max' => 15,
					'defaultUnit' => 'vw',
					'responsive' => true,
					'divider' => 'top',
					'sync' => 'live',
					'desc' => __( 'Adjusts horizontal spacing between main content area and edges of the screen.', 'noorgfx' ),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'narrowContainerWidth' => [
					'label' => __( 'Narrow Container Max Width', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => 750,
					'min' => 400,
					'max' => 1000,
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'This option applies only if the posts or pages are set to Narrow Width structure.', 'noorgfx' ),
				],

				'wideOffset' => [
					'label' => __( 'Wide Alignment Offset', 'noorgfx' ),
					'type' => 'ct-slider',
					'defaultUnit' => 'px',
					'value' => 130,
					'min' => 20,
					'max' => 200,
					'divider' => 'top',
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'This option will apply only to those elements that have a wide alignment option.', 'noorgfx' ),
				],

		],
	],

];
