<?php
/**
 * Forms options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'form_elements_panel' => [
		'label' => __( 'Form Elements', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'forms_type' => [
						'label' => false,
						'type' => 'ct-image-picker',
						'value' => 'classic-forms',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [

							'classic-forms' => [
								'src'   => noorgfx_image_picker_url( 'forms-type-1.svg' ),
								'title' => __( 'Classic', 'noorgfx' ),
							],

							'modern-forms' => [
								'src'   => noorgfx_image_picker_url( 'forms-type-2.svg' ),
								'title' => __( 'Modern', 'noorgfx' ),
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-title',
						'label' => __( 'Form Fields', 'noorgfx' ),
					],

					'formInputHeight' => [
						'label' => __( 'Height', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 40,
						'min' => 20,
						'max' => 80,
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'formTextAreaHeight' => [
						'label' => __( 'Textarea Height', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 170,
						'min' => 50,
						'max' => 250,
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'formBorderSize' => [
						'label' => __( 'Border Size', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 1,
						'min' => 1,
						'max' => 5,
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'forms_type' => 'classic-forms' ],
						'options' => [

							'formFieldBorderRadius' => [
								'label' => __( 'Border Radius', 'noorgfx' ),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 3,
								'min' => 0,
								'max' => 200,
								'setting' => [ 'transport' => 'postMessage' ],
							],

						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [
					[
						'form_font' => [
							'type' => 'ct-typography',
							'label' => __( 'Font', 'noorgfx' ),
							'value' => noorgfx_typography_default_values([]),
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'formTextColor' => [
							'label' => __( 'Font Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'focus' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Focus', 'noorgfx' ),
									'id' => 'focus',
									'inherit' => 'var(--theme-text-color)'
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Form Fields', 'noorgfx' ),
						],

						'formBorderColor' => [
							'label' => __( 'Border Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'var(--theme-border-color)',
								],

								'focus' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Focus', 'noorgfx' ),
									'id' => 'focus',
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'forms_type' => 'classic-forms' ],
							'options' => [

								'formBackgroundColor' => [
									'label' => __( 'Background Color', 'noorgfx' ),
									'type'  => 'ct-color-picker',
									'design' => 'inline',
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => [
										'default' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
										],

										'focus' => [
											'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
										],
									],

									'pickers' => [
										[
											'title' => __( 'Initial', 'noorgfx' ),
											'id' => 'default',
										],

										[
											'title' => __( 'Focus', 'noorgfx' ),
											'id' => 'focus',
										],
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Radio & Checkbox', 'noorgfx' ),
						],

						'radioCheckboxColor' => [
							'label' => __( 'Colors', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'var(--theme-border-color)',
								],

								'accent' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
								],

								[
									'title' => __( 'Active', 'noorgfx' ),
									'id' => 'accent',
								],
							],
						],

					],

					// 'checkboxBorderRadius' => [
					// 	'label' => __( 'Checkbox Border Radius', 'noorgfx' ),
					// 	'type' => 'ct-number',
					// 	'design' => 'inline',
					// 	'value' => 3,
					// 	'min' => 0,
					// 	'max' => 10,
					// 	'setting' => [ 'transport' => 'postMessage' ],
					// ],

					function_exists('WC') ? [
						noorgfx_rand_md5() => [
							'type' => 'ct-title',
							'label' => __( 'Select Dropdown', 'noorgfx' ),
						],

						'formSelectFontColor' => [
							'label' => __( 'Font Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'active' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],

								[
									'title' => __( 'Active', 'noorgfx' ),
									'id' => 'active',
									'inherit' => '#ffffff'
								],
							],
						],

						'formSelectBackgroundColor' => [
							'label' => __( 'Background Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'active' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => '#ffffff'
								],

								[
									'title' => __( 'Active', 'noorgfx' ),
									'id' => 'active',
									'inherit' => 'var(--theme-palette-color-1)'
								],
							],
						],

					] : [],
				],
			],
		]
	]
];
