<?php
/**
 * Buttons options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'buttons_panel' => [
		'label' => __( 'Buttons', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'buttonMinHeight' => [
						'label' => __( 'Min Height', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 30,
						'max' => 100,
						'value' => 40,
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'buttonHoverEffect' => [
						'label' => __( 'Hover Effect', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'buttonTextColor' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'skipEditPalette' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => '#ffffff',
							],

							'hover' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'buttonColor' => [
						'label' => __( 'Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'skipEditPalette' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => 'var(--theme-palette-color-1)',
							],

							'hover' => [
								'color' => 'var(--theme-palette-color-2)',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'buttonBorder' => [
						'label' => __( 'Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'inline',
						'sync' => 'live',
						'divider' => 'top',
						'secondColor' => true,
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => 'rgba(224, 229, 235, 0.5)',
							],

							'secondColor' => [
								'color' => 'rgba(224, 229, 235, 0.7)',
							],
						],
					],

					'buttonPadding' => [
						'label' => __( 'Padding', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value([
							'top' => '5px',
							'left' => '20px',
							'right' => '20px',
							'bottom' => '5px',
						]),
						'min' => 0,
						'responsive' => true
					],

					'buttonRadius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value(),
						'inputAttr' => [
							'placeholder' => '3'
						],
						'min' => 0,
						'responsive' => true
					],

				],
			],
		],
	],
];
