<?php
/**
 * Back to top options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$is_pro = function_exists('blc_site_has_feature') && blc_site_has_feature('base_pro');

$options = [

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	'has_back_top' => [
		'label' => __( 'Scroll to Top', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'no',
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [
					$is_pro ? [
						'top_button_icon_source' => [
							'label' => __( 'Icon Source', 'noorgfx' ),
							'type' => 'ct-radio',
							'value' => 'default',
							'view' => 'text',
							'design' => 'block',
							'choices' => [
								'default' => __( 'Default', 'noorgfx' ),
								'custom' => __( 'Custom', 'noorgfx' ),
							],
							'sync' => [
								'selector' => '.ct-back-to-top',
								'container_inclusive' => true,
								'render' => function () {
									noorgfx_output_back_to_top_link();
								}
							]
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['top_button_icon_source' => 'custom'],
							'options' => [
								'top_button_icon' => [
									'type' => 'icon-picker',
									'label' => __('Icon', 'noorgfx'),
									'design' => 'inline',
									'value' => [
										'icon' => 'blc blc-arrow-up-circle'
									],
									'sync' => [
										'container_inclusive' => true,
										'selector' => '.ct-back-to-top',
										'render' => function () {
											noorgfx_output_back_to_top_link();
										}
									]
								]
							]
						]
					]: [],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => $is_pro ? [
							'top_button_icon_source' => 'default'
						] : [
							'top_button_icon_source' => '! not_existing'
						],
						'options' => [
							'top_button_type' => [
								'label' => false,
								'type' => 'ct-image-picker',
								'value' => 'type-1',
								'attr' => [
									'data-type' => 'background',
									'data-columns' => '3',
								],
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' => [

									'type-1' => [
										'src'   => noorgfx_image_picker_file( 'top-1' ),
										'title' => __( 'Type 1', 'noorgfx' ),
									],

									'type-2' => [
										'src'   => noorgfx_image_picker_file( 'top-2' ),
										'title' => __( 'Type 2', 'noorgfx' ),
									],

									'type-3' => [
										'src'   => noorgfx_image_picker_file( 'top-3' ),
										'title' => __( 'Type 3', 'noorgfx' ),
									],

									'type-4' => [
										'src'   => noorgfx_image_picker_file( 'top-4' ),
										'title' => __( 'Type 4', 'noorgfx' ),
									],

									'type-5' => [
										'src'   => noorgfx_image_picker_file( 'top-5' ),
										'title' => __( 'Type 5', 'noorgfx' ),
									],

									'type-6' => [
										'src'   => noorgfx_image_picker_file( 'top-6' ),
										'title' => __( 'Type 6', 'noorgfx' ),
									],
								],
								'sync' => [
									'selector' => '.ct-back-to-top',
									'container_inclusive' => true,
									'render' => function () {
										noorgfx_output_back_to_top_link();
									}
								]
							]
						]
					],

					'top_button_shape' => [
						'label' => __( 'Button Shape', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'square',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'square' => __( 'Square', 'noorgfx' ),
							'circle' => __( 'Circle', 'noorgfx' ),
						],
					],

					'topButtonSize' => [
						'label' => __( 'Icon Size', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 10,
						'max' => 50,
						'value' => 12,
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'topButtonOffset' => [
						'label' => __( 'Bottom Offset', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 5,
						'max' => 300,
						'value' => 25,
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'sideButtonOffset' => [
						'label' => __( 'Side Offset', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 5,
						'max' => 300,
						'value' => 25,
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'top_button_alignment' => [
						'label' => __( 'Alignment', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'right',
						'setting' => [ 'transport' => 'postMessage' ],
						'view' => 'text',
						'divider' => 'top',
						'attr' => [ 'data-type' => 'alignment' ],
						'choices' => [
							'left' => '',
							'right' => '',
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					'back_top_visibility' => [
						'label' => __( 'Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => false,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'topButtonIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => '#ffffff',
							],

							'hover' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'topButtonShapeBackground' => [
						'label' => __( 'Shape Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-palette-color-3)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-4)'
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'top_button_shape' => 'square' ],
						'options' => [

							'topButtonRadius' => [
								'label' => __( 'Shape Border Radius', 'noorgfx' ),
								'type' => 'ct-spacing',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => noorgfx_spacing_value(),
								'inputAttr' => [
									'placeholder' => '2'
								],
								'min' => 0,
							],

						],
					],

					'topButtonShadow' => [
						'label' => __( 'Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'divider' => 'top',
						'design' => 'inline',
						// 'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_box_shadow_value([
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 5,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(210, 213, 218, 0.2)',
							],
						])
					],

				],
			],

		],
	],
];
