<?php
/**
 * Social Accounts
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$social_networks_options = [];

foreach (noorgfx_get_social_networks_list() as $id => $network) {
	$social_section_options[$id] = [
		'label' => $network['label'],
		'type' => 'text',
		'design' => 'block',
		'value' => '',
		'setting' => [ 'transport' => 'postMessage' ],
	];
}

$options = [
	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],
	
	'social_section_options' => [
		'label' => __( 'Social Network Accounts', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [
			[
				noorgfx_rand_md5() => [
					'label' => __( 'Social Network Accounts', 'noorgfx' ),
					'type' => 'ct-title',
					'desc' => __( 'Easily link your social media accounts and display them throughout your website, with the various elements provided in the customizer.', 'noorgfx' ),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],
			],

			$social_section_options
		],
	],
];
