<?php

do_action(
	'noorgfx:global-dynamic-css:enqueue:singular',
	[
		'context' => $context,
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'atts' => $atts,
		'post_id' => $post_id,
		'post_type' => $post_type,
		'prefix' => $prefix
	]
);

$hero_mode = noorgfx_akg('has_hero_section', $atts, 'default');

if ($hero_mode === 'enabled') {
	noorgfx_theme_get_dynamic_styles([
		'name' => 'page-title/page-title',
		'css' => $css,
		'mobile_css' => $mobile_css,
		'tablet_css' => $tablet_css,
		'context' => $context,
		'chunk' => 'inline',
		'prefix' => $prefix,
		'source' => [
			'strategy' => $atts
		]
	]);
}

$default_content_style = noorgfx_default_akg(
	'content_style_source',
	$atts,
	'inherit'
);

noorgfx_output_background_css([
	'selector' => noorgfx_prefix_selector('', $prefix),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_default_akg(
		'background',
		$atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
				],
			],
		])
	),
	'responsive' => true,
	'forced_background_image' => true
]);

if ($default_content_style === 'custom') {
	noorgfx_theme_get_dynamic_styles([
		'name' => 'global/single-content',
		'css' => $css,
		'mobile_css' => $mobile_css,
		'tablet_css' => $tablet_css,
		'context' => $context,
		'chunk' => 'inline',
		'prefix' => $prefix,
		'source' => [
			'strategy' => $atts
		]
	]);
}

