<?php

if (noorgfx_get_theme_mod($prefix . '_has_share_box', 'no') === 'yes') {
	$share_box_icon_size = noorgfx_get_theme_mod($prefix . '_share_box_icon_size', '15px');
	$share_box_type = noorgfx_get_theme_mod($prefix. '_share_box_type', 'type-1');

	if ($share_box_icon_size !== '15px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-share-box', $prefix),
			'variableName' => 'theme-icon-size',
			'value' => $share_box_icon_size,
			'unit' => '',
		]);
	}

	$share_box_icons_spacing = noorgfx_get_theme_mod($prefix . '_share_box_icons_spacing', '15px');

	if ($share_box_icons_spacing !== '15px' && $share_box_type !== 'type-1') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-share-box', $prefix),
			'variableName' => 'items-spacing',
			'value' => $share_box_icons_spacing,
			'unit' => '',
		]);
	}

	$top_share_box_spacing = noorgfx_get_theme_mod($prefix . '_top_share_box_spacing', '50px');
	if ($top_share_box_spacing !== '50px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-share-box[data-location="top"]', $prefix),
			'variableName' => 'margin',
			'value' => $top_share_box_spacing,
			'unit' => ''
		]);
	}

	$bottom_share_box_spacing = noorgfx_get_theme_mod($prefix . '_bottom_share_box_spacing', '50px');
	if ($bottom_share_box_spacing !== '50px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-share-box[data-location="bottom"]', $prefix),
			'variableName' => 'margin',
			'value' => $bottom_share_box_spacing,
			'unit' => ''
		]);
	}

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod($prefix . '_share_box_title_font',
			noorgfx_typography_default_values([
				'size' => '14px',
				'variation' => 'n6',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-share-box .ct-module-title', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_share_box_title_color'),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-share-box .ct-module-title', $prefix),
				'variable' => 'theme-heading-color'
			],
		],
	]);


	if ($share_box_type === 'type-1') {
		noorgfx_output_colors([
			'value' => noorgfx_get_theme_mod($prefix . '_share_items_icon_color', []),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'variables' => [
				'default' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-1"]', $prefix),
					'variable' => 'theme-icon-color'
				],

				'hover' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-1"]', $prefix),
					'variable' => 'theme-icon-hover-color'
				],
			],
		]);

		noorgfx_output_border([
			'css' => $css,
			'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-1"]', $prefix),
			'variableName' => 'theme-border',
			'value' => noorgfx_get_theme_mod($prefix . '_share_items_border'),
			'default' => [
				'width' => 1,
				'style' => 'solid',
				'color' => [
					'color' => 'var(--theme-border-color)',
				],
			]
		]);
	}


	if ($share_box_type === 'type-2') {

		$share_box_alignment = noorgfx_get_theme_mod($prefix . '_share_box_alignment', 'CT_CSS_SKIP_RULE');

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-2"]', $prefix),
			'variableName' => 'horizontal-alignment',
			'value' => $share_box_alignment,
			'unit' => '',
		]);
	}


	$share_box2_colors = noorgfx_get_theme_mod($prefix. '_share_box2_colors', 'custom');

	if ($share_box_type === 'type-2' && $share_box2_colors === 'custom') {
		noorgfx_output_colors([
			'value' => noorgfx_get_theme_mod(
				$prefix . '_share_items_icon',
				[]
			),
			'default' => [
				'default' => [ 'color' => '#ffffff' ],
				'hover' => [ 'color' => '#ffffff' ],
			],
			'css' => $css,
			'variables' => [
				'default' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-2"]', $prefix),
					'variable' => 'theme-icon-color'
				],

				'hover' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-2"]', $prefix),
					'variable' => 'theme-icon-hover-color'
				],
			],
		]);

		noorgfx_output_colors([
			'value' => noorgfx_get_theme_mod($prefix . '_share_items_background', []),
			'default' => [
				'default' => [ 'color' => 'var(--theme-palette-color-1)' ],
				'hover' => [ 'color' => 'var(--theme-palette-color-2)' ],
			],
			'css' => $css,
			'variables' => [
				'default' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-2"]', $prefix),
					'variable' => 'background-color'
				],

				'hover' => [
					'selector' => noorgfx_prefix_selector('.ct-share-box[data-type="type-2"]', $prefix),
					'variable' => 'background-hover-color'
				]
			],
		]);
	}
}


// featured image
if (noorgfx_get_theme_mod($prefix . '_has_featured_image', 'no') === 'yes') {

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-featured-image', $prefix),
		'property' => 'theme-border-radius',
		'value' => noorgfx_get_theme_mod(
			$prefix . '_featured_image_border_radius',
			noorgfx_spacing_value()
		)
	]);
}


// author box
if (
	noorgfx_get_theme_mod($prefix . '_has_author_box', 'no') === 'yes'
	&&
	$prefix !== 'single_page'
) {

	$author_box_spacing = noorgfx_get_theme_mod($prefix. '_single_author_box_spacing', '40px');

	if ($author_box_spacing !== '40px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.author-box', $prefix),
			'variableName' => 'spacing',
			'value' => $author_box_spacing,
			'unit' => ''
		]);
	}

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod(
			$prefix . '_single_author_box_name_font',
			noorgfx_typography_default_values([])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.author-box .author-box-name', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_name_color'),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-name', $prefix),
				'variable' => 'theme-heading-color'
			],
		],

		'responsive' => true
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod(
			$prefix . '_single_author_box_font',
			noorgfx_typography_default_values([])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.author-box .author-box-bio', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_font_color', []),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-bio', $prefix),
				'variable' => 'theme-text-color'
			],

			'initial' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-bio', $prefix),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-bio', $prefix),
				'variable' => 'theme-link-hover-color'
			],
		],

		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_social_icons_color', []),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-socials', $prefix),
				'variable' => 'theme-icon-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-socials', $prefix),
				'variable' => 'theme-icon-hover-color'
			]
		],

		'responsive' => true
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_social_icons_background', []),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-socials', $prefix),
				'variable' => 'background-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.author-box .author-box-socials', $prefix),
				'variable' => 'background-hover-color'
			]
		],

		'responsive' => true
	]);


	$author_box_type = noorgfx_get_theme_mod($prefix. '_single_author_box_type', 'type-2');

	if ($author_box_type === 'type-1') {

		noorgfx_output_background_css([
			'selector' => noorgfx_prefix_selector('.author-box[data-type="type-1"]', $prefix),
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'value' => noorgfx_get_theme_mod(
				$prefix . '_single_author_box_container_background',
				noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => 'var(--theme-palette-color-8)'
						],
					],
				])
			),
			'responsive' => true,
		]);

		noorgfx_output_box_shadow([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.author-box[data-type="type-1"]', $prefix),
			'value' => noorgfx_get_theme_mod(
				$prefix . '_single_author_box_shadow',
				noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 50,
					'blur' => 90,
					'spread' => 0,
					'inset' => false,
					'color' => [
						'color' => 'rgba(210, 213, 218, 0.4)',
					],
				])
			),
			'responsive' => true
		]);

		noorgfx_output_border([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.author-box[data-type="type-1"]', $prefix),
			'variableName' => 'theme-border',
			'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_container_border'),
			'default' => [
				'width' => 1,
				'style' => 'none',
				'color' => [
					'color' => 'rgba(44,62,80,0.2)',
				],
			],
			'responsive' => true,
			// 'skip_none' => true
		]);

		noorgfx_output_spacing([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.author-box[data-type="type-1"]', $prefix),
			'property' => 'theme-border-radius',
			'value' => noorgfx_get_theme_mod(
				$prefix . '_single_author_box_border_radius',
				noorgfx_spacing_value()
			)
		]);
	}

	if ($author_box_type === 'type-2') {
		noorgfx_output_colors([
			'value' => noorgfx_get_theme_mod($prefix . '_single_author_box_border', []),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,

			'variables' => [
				'default' => [
					'selector' => noorgfx_prefix_selector('.author-box[data-type="type-2"]', $prefix),
					'variable' => 'theme-border-color'
				],
			],

			'responsive' => true,
		]);
	}
}

// post tags
if (
	noorgfx_get_theme_mod($prefix . '_has_post_tags', 'no') === 'yes'
	&&
	$prefix !== 'single_page'
) {

	$post_tags_alignment = noorgfx_get_theme_mod($prefix . '_post_tags_alignment', 'CT_CSS_SKIP_RULE');

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-tags', $prefix),
		'variableName' => 'horizontal-alignment',
		'value' => $post_tags_alignment,
		'unit' => '',
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod($prefix . '_post_tags_title_font',
			noorgfx_typography_default_values([
				'size' => '14px',
				'variation' => 'n6',
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-tags .ct-module-title', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_post_tags_title_color'),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.entry-tags .ct-module-title', $prefix),
				'variable' => 'theme-heading-color'
			],
		],
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-tags-items', $prefix),
		'property' => 'theme-border-radius',
		'value' => noorgfx_get_theme_mod(
			$prefix . '_post_tags_border_radius',
			noorgfx_spacing_value()
		)
	]);

}


// posts navigation
if (
	noorgfx_get_theme_mod($prefix . '_has_post_nav', 'no') === 'yes'
	&&
	$prefix !== 'single_page'
) {

	$post_nav_spacing = noorgfx_get_theme_mod($prefix . '_post_nav_spacing', '50px');

	if ($post_nav_spacing !== '50px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.post-navigation', $prefix),
			'variableName' => 'margin',
			'value' => $post_nav_spacing,
			'unit' => ''
		]);
	}

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_posts_nav_font_color', []),
		'default' => [
			'default' => [ 'color' => 'var(--theme-text-color)' ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.post-navigation', $prefix),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.post-navigation', $prefix),
				'variable' => 'theme-link-hover-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_posts_nav_image_overlay_color', []),
		'default' => [
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'hover' => [
				'selector' => noorgfx_prefix_selector('.post-navigation', $prefix),
				'variable' => 'image-overlay-color'
			],
		],
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.post-navigation figure', $prefix),
		'property' => 'theme-border-radius',
		'value' => noorgfx_get_theme_mod(
			$prefix . '_posts_nav_image_border_radius',
			noorgfx_spacing_value()
		),
		'empty_value' => 100,
	]);
}


// related posts
if (
	noorgfx_get_theme_mod($prefix . '_has_related_posts', 'no') === 'yes'
	&&
	$prefix !== 'single_page'
) {

	$related_posts_container_spacing = noorgfx_get_theme_mod($prefix . '_related_posts_container_spacing', '50px');

	if ($related_posts_container_spacing !== '50px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.ct-related-posts-container', $prefix),
			'variableName' => 'padding',
			'value' => $related_posts_container_spacing,
			'unit' => ''
		]);
	}

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-related-posts .ct-module-title', $prefix),
		'variableName' => 'horizontal-alignment',
		'value' => noorgfx_get_theme_mod($prefix . '_related_label_alignment', 'CT_CSS_SKIP_RULE'),
		'unit' => '',
	]);

	noorgfx_output_background_css([
		'selector' => noorgfx_prefix_selector('.ct-related-posts-container', $prefix),
		'css' => $css,
		'value' => noorgfx_get_theme_mod(
			$prefix . '_related_posts_background',
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'var(--theme-palette-color-6)'
					],
				],
			])
		)
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod(
			$prefix . '_related_posts_label_font',
			noorgfx_typography_default_values([])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-related-posts .ct-module-title', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_related_posts_label_color'),
		'default' => [
			'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts .ct-module-title', $prefix),
				'variable' => 'theme-heading-color'
			],
		],
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod(
			$prefix . '_related_posts_link_font',
			noorgfx_typography_default_values([
				'size' => '16px'
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-related-posts .related-entry-title', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_related_posts_link_color'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts .related-entry-title', $prefix),
				'variable' => 'theme-heading-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts .related-entry-title', $prefix),
				'variable' => 'theme-link-hover-color'
			],
		],
	]);

	noorgfx_output_font_css([
		'font_value' => noorgfx_get_theme_mod(
			$prefix . '_related_posts_meta_font',
			noorgfx_typography_default_values([
				'size' => '14px'
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-related-posts .entry-meta', $prefix),
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_related_posts_meta_color'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts .entry-meta', $prefix),
				'variable' => 'theme-text-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts .entry-meta', $prefix),
				'variable' => 'theme-link-hover-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_related_meta_button_type_font_colors'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts [data-type="pill"]', $prefix),
				'variable' => 'theme-button-text-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts [data-type="pill"]', $prefix),
				'variable' => 'theme-button-text-hover-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod($prefix . '_related_meta_button_type_background_colors'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts [data-type="pill"]', $prefix),
				'variable' => 'theme-button-background-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_prefix_selector('.ct-related-posts [data-type="pill"]', $prefix),
				'variable' => 'theme-button-background-hover-color'
			],
		],
	]);


	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.ct-related-posts .ct-media-container', $prefix),
		'property' => 'theme-border-radius',
		'value' => noorgfx_get_theme_mod(
			$prefix . '_related_thumb_radius',
			noorgfx_spacing_value()
		),
		'empty_value' => 5
	]);


	$relatedNarrowWidth = noorgfx_get_theme_mod($prefix . '_related_narrow_width', 750 );

	if ($relatedNarrowWidth !== 750) {
		$css->put(
			noorgfx_prefix_selector('.ct-related-posts-container', $prefix),
			'--theme-narrow-container-max-width: ' . $relatedNarrowWidth . 'px'
		);
	}

	$grid_columns = noorgfx_expand_responsive_value(noorgfx_get_theme_mod(
		$prefix . '_related_posts_columns',
		[
			'desktop' => 3,
			'tablet' => 2,
			'mobile' => 1
		]
	));

	$columns_for_output = [
		'desktop' => 'repeat(' . $grid_columns['desktop'] . ', minmax(0, 1fr))',
		'tablet' => 'repeat(' . $grid_columns['tablet'] . ', minmax(0, 1fr))',
		'mobile' => 'repeat(' . $grid_columns['mobile'] . ', minmax(0, 1fr))'
	];

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector(
			'.ct-related-posts',
			$prefix
		),
		'variableName' => 'grid-template-columns',
		'value' => $columns_for_output,
		'unit' => ''
	]);


	// related posts layers
	foreach (noorgfx_get_theme_mod($prefix . '_related_order', []) as $layer) {
		if (! $layer['enabled']) {
			continue;
		}

		// bottom spacing
		$selectors_map = [
			'title' => '.ct-related-posts .related-entry-title',
			'featured_image' => '.ct-related-posts .ct-media-container',
		];
	
		$spacing_default = 20;
	
		if ($layer['id'] === 'title') {
			$spacing_default = 5;
		}
	
		$spacing = noorgfx_akg('spacing', $layer, $spacing_default);
	
		if (
			isset($selectors_map[$layer['id']])
			&&
			(
				intval($spacing) !== $spacing_default
				||
				$spacing_default === 5
			)
		) {
			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => noorgfx_prefix_selector(
					$selectors_map[$layer['id']],
					$prefix
				),
				'variableName' => 'card-element-spacing',
				'value' => $spacing
			]);
		}
		
		if ($layer['id'] === 'post_meta') {
			$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);
	
			if ($spacing !== 20) {
				noorgfx_output_responsive([
					'css' => $css,
					'tablet_css' => $tablet_css,
					'mobile_css' => $mobile_css,
					'selector' => noorgfx_prefix_selector(
						'.ct-related-posts .entry-meta[data-id="' . $id . '"]',
						$prefix
					),
					'variableName' => 'card-element-spacing',
					'value' => $spacing,
					'unit' => 'px'
				]);
			}
		}
	
		if ($layer['id'] === 'content-block') {
			$id = isset($layer["__id"]) ? $layer["__id"] : 'default';
	
			if ($spacing !== 20) {
				noorgfx_output_responsive([
					'css' => $css,
					'tablet_css' => $tablet_css,
					'mobile_css' => $mobile_css,
					'selector' => noorgfx_prefix_selector(
						'.ct-related-posts .ct-entry-content-block[data-id="' . $id . '"]',
						$prefix
					),
					'variableName' => 'card-element-spacing',
					'value' => $spacing,
					'unit' => 'px'
				]);
			}
		}
	
		if (in_array(
			$layer['id'],
			[
				'acf_field',
				'metabox_field',
				'toolset_field',
				'jetengine_field',
				'custom_field',
				'pods_field',
			]
		)) {
			$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);
	
			if ($spacing !== 20) {
				noorgfx_output_responsive([
					'css' => $css,
					'tablet_css' => $tablet_css,
					'mobile_css' => $mobile_css,
					'selector' => noorgfx_prefix_selector(
						'.ct-related-posts .ct-dynamic-data-layer[data-field*=":' . $id . '"]',
						$prefix
					),
					'variableName' => 'card-element-spacing',
					'value' => $spacing,
					'unit' => 'px'
				]);
			}
		}
	}
}