<?php

if (noorgfx_get_theme_mod($prefix . '_has_comments', 'yes') !== 'yes') {
	return;
}

$comments_narrow_width = noorgfx_get_theme_mod($prefix. '_comments_narrow_width', 750);

if ($comments_narrow_width !== 750) {
	$css->put(
		noorgfx_prefix_selector('.ct-comments-container', $prefix),
		'--theme-narrow-container-max-width: ' . $comments_narrow_width . 'px'
	);
}

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_comments_author_name_font_color',
		[
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		]
	),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.ct-comments .ct-comment-author', $prefix),
			'variable' => 'theme-heading-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector('.ct-comments .ct-comment-author', $prefix),
			'variable' => 'theme-link-hover-color'
		],
	],
]);


noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_comments_font_color',
		[
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		]
	),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.ct-comments', $prefix),
			'variable' => 'theme-text-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector('.ct-comments', $prefix),
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_background_css([
	'selector' => noorgfx_prefix_selector('.ct-comments-container', $prefix),
	'css' => $css,
	'value' => noorgfx_get_theme_mod(
		$prefix . '_comments_background',
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
				],
			],
		])
	)
]);
