<?php

function noorgfx_woocommerce_has_flexy_view() {
	global $noorgfx_is_quick_view;

	if ($noorgfx_is_quick_view) {
		return true;
	}

	if (is_customize_preview() && wp_doing_ajax()) {
		return true;
	}

	$is_variations_action = (isset($_REQUEST['action'])
		&&
		$_REQUEST['action'] === 'woocommerce_load_variations'
	);

	if (isset($_REQUEST['wc-ajax']) && $_REQUEST['wc-ajax'] === 'get_variation') {
		$is_variations_action = true;
	}

	if (
		(
			noorgfx_manager()->screen->is_product()
			||
			wp_doing_ajax()
		)
		&&
		! noorgfx_manager()->screen->uses_woo_default_template()
		&&
		! is_customize_preview()
		&&
		! $is_variations_action
	) {
		return false;
	}

	return !apply_filters('noorgfx:woocommerce:product-view:use-default', false);
}

add_action('init', function() {
	noorgfx_manager()->woocommerce->single->register_translations();
});

if (!wp_doing_ajax()) {
	add_filter('template_include', function ($template) {
		if (noorgfx_woocommerce_has_flexy_view()) {
			remove_action(
				'woocommerce_product_thumbnails',
				'woocommerce_show_product_thumbnails',
				20
			);
		}

		return $template;
	}, 900000009);
} else {
	add_action('init', function () {
		if (noorgfx_woocommerce_has_flexy_view()) {
			remove_action(
				'woocommerce_product_thumbnails',
				'woocommerce_show_product_thumbnails',
				20
			);
		}
	});
}

add_filter('noorgfx_woo_single_options_layers:defaults', function ($opt) {
	return array_merge($opt, [
		[
			'id' => 'product_tabs',
			'enabled' => true,
		],
	]);
});

add_filter('noorgfx_woo_single_right_options_layers:defaults', function ($opt) {
	return array_merge($opt, [
		[
			'id' => 'product_tabs',
			'enabled' => true,
		],
	]);
});

add_filter('noorgfx_woo_single_options_layers:extra', function ($opt) {
	return array_merge($opt, [
		'product_tabs' => [
			'label' => __('Product Tabs', 'noorgfx'),
			'condition' => [
				'all' => [
					'woo_tabs_type' => 'type-3|type-4',
					'woo_accordion_in_summary' => 'summary',
				]
			],
			'options' => [
				'spacing' => [
					'label' => __('Bottom Spacing', 'noorgfx'),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip',
					],
				],
			],
		]
	]);
});

add_action(
	'noorgfx:woocommerce:product:custom:layer',
	function ($layer, $classes = 'ct-product-tabs') {
		if (
			$layer['id'] === 'product_tabs'
			&&
			noorgfx_get_theme_mod('woo_accordion_in_summary', 'default') === 'summary'
		) {
			$tabs_type = noorgfx_get_theme_mod('woo_tabs_type', 'type-1');
			$res = $tabs_type;

			$result = '';

			ob_start();
			if ($tabs_type === 'type-3') {
				$result = noorgfx_custom_accordion_tabs();
			}

			if ($tabs_type === 'type-4') {
				$result = noorgfx_custom_simple_tabs();
			}

			$result = ob_get_clean();

			$res .= ':' . noorgfx_get_theme_mod('woo_tabs_alignment', 'center');

			echo str_replace(
				'wc-tabs-wrapper"',
				'wc-tabs-wrapper" data-type="' . $res . '"',
				$result
			);
		}
	}
);

$action_to_hook = 'wp';

if (wp_doing_ajax()) {
	$action_to_hook = 'init';
}

add_action($action_to_hook, function () {
	noorgfx_manager()->woocommerce->single->receive_initial_woo_behavior([
		// Validation by priority might be needed to ensure consistency.
		// This way we can also validate if other plugins interfered with the
		// action.
		'product_add_to_cart' => has_action(
			'woocommerce_single_product_summary',
			'woocommerce_template_single_add_to_cart'
		)
	]);

	// Remove default WooCommerce actions a little later, so we can check if
	// someone else has removed them before us.
	// This way, we will skip the layers that are disabled by the user or some
	// plugin.
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);

	if (noorgfx_get_theme_mod('woo_has_product_tabs', 'yes') === 'no') {
		add_filter('woocommerce_product_tabs', function ($tabs) {
			return [];
		}, 99);
	} else {
		$tabs_type = noorgfx_get_theme_mod('woo_tabs_type', 'type-1');

		if (
			noorgfx_get_theme_mod('woo_has_product_tabs_description', 'no') === 'no'
			&&
			$tabs_type !== 'type-4'
		) {
			add_filter(
				'woocommerce_product_description_heading',
				'__return_null'
			);

			add_filter(
				'woocommerce_product_additional_information_heading',
				'__return_null'
			);
		}
	}

	add_action(
		'woocommerce_before_single_product',
		function() {
			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_before_title',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:title:before',

				'priority_min' => 2,
				'priority_max' => 4
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_after_title',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:title:after',

				'priority_min' => 5,
				'priority_max' => 10
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_after_price',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:price:after',

				'priority_min' => 11,
				'priority_max' => 20
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_after_excerpt',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:excerpt:after',

				'priority_min' => 20,
				'priority_max' => 30
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_after_add_to_cart',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:add_to_cart:after',

				'priority_min' => 30,
				'priority_max' => 40
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_after_meta',
				'source' => ['woocommerce_single_product_summary'],
				'destination' => 'noorgfx:woocommerce:product-single:meta:after',

				'priority_min' => 40,
				'priority_max' => 50
			]);

			noorgfx_manager()->get_hooks()->redirect_callbacks([
				'token' => 'single_product_sharing',
				'source' => ['woocommerce_share'],
				'destination' => 'noorgfx:woocommerce:product-single:layout:after'
			]);
		}
	);

	$product_view_type = noorgfx_get_product_view_type();

	if (
		$product_view_type === 'default-gallery'
		||
		$product_view_type === 'stacked-gallery'
	) {
		add_action(
			'woocommerce_single_product_summary',
			function () {
				noorgfx_manager()->woocommerce->single->render_layout(
					[
						'defaults' => noorgfx_get_woo_single_layout_defaults()
					]
				);
			},
			1
		);
	}
}, 9000000000);

add_action(
	'woocommerce_after_single_product_summary',
	function () {
		do_action('noorgfx:woocommerce:product-single:tabs:before');
	},
	9
);

add_action(
	'woocommerce_after_single_product_summary',
	function () {
		do_action('noorgfx:woocommerce:product-single:tabs:after');
	},
	11
);

add_action(
	'woocommerce_before_single_product_summary',
	function () {
		global $noorgfx_single_product_summary_buffering_started;
		$noorgfx_single_product_summary_buffering_started = true;

		echo '<div class="product-entry-wrapper is-width-constrained">';
		ob_start();
	},
	1
);

add_action('woocommerce_single_product_summary', function () {
	global $noorgfx_single_product_summary_buffering_started;

	if (! $noorgfx_single_product_summary_buffering_started) {
		return;
	}

	$product_view_type = noorgfx_get_product_view_type();

	$content = ob_get_clean();

	$prefix = noorgfx_manager()->screen->get_prefix();

	$deep_link_args = [
		'prefix' => $prefix,
		'suffix' => 'woo_product_elements',
		'shortcut' => 'border'
	];

	$content = str_replace(
		'class="summary',
		noorgfx_generic_get_deep_link($deep_link_args) . ' class="summary',
		$content
	);

	if (
		$product_view_type !== 'top-gallery'
		&&
		$product_view_type !== 'columns-top-gallery'
	) {
		$content = str_replace(
			'entry-summary',
			'entry-summary entry-summary-items',
			$content
		);
	}

	echo $content;
}, 0);

add_action(
	'woocommerce_after_single_product_summary',
	function () {
		echo '</div>';
	},
	1
);

remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

add_action(
	'woocommerce_before_single_product',
	function() {
		noorgfx_manager()->get_hooks()->redirect_callbacks([
			'token' => 'single_product_after_ralated',
			'source' => ['woocommerce_after_single_product'],
			'destination' => 'noorgfx:woocommerce:product-single:related:after',
		]);
	}
);

add_action(
	'woocommerce_after_main_content',
	function() {
		noorgfx_woo_single_product_after_main_content();

		do_action('noorgfx:woocommerce:product-single:related:after');
	},
	5
);

if (! function_exists('noorgfx_woo_single_product_after_main_content')) {
	function noorgfx_woo_single_product_after_main_content() {
		if (
			! noorgfx_manager()->screen->is_product()
			||
			noorgfx_get_theme_mod('woo_has_related_upsells', 'yes') !== 'yes'
		) {
			return;
		}

		if (
			noorgfx_some_device(
				noorgfx_get_theme_mod(
					'upsell_products_visibility',
					[
						'desktop' => true,
						'tablet' => false,
						'mobile' => false,
					]
				)
			)
			||
			is_customize_preview()
		) {
			woocommerce_upsell_display();
		}

		if (
			noorgfx_some_device(noorgfx_get_theme_mod(
				'related_products_visibility',
				[
					'desktop' => true,
					'tablet' => false,
					'mobile' => false,
				]
			))
			||
			is_customize_preview()
		) {
			woocommerce_output_related_products();
		}
	}
}

add_filter('woocommerce_output_related_products_args', function ($args) {
	$columns = intval(
		noorgfx_expand_responsive_value(
			noorgfx_get_theme_mod(
				'woo_product_related_cards_columns',
				[
					'desktop' => 4,
					'tablet' => 3,
					'mobile' => 1
				]
			)
		)['desktop']
	);

	$args['columns'] = $columns;
	$args['posts_per_page'] = $columns * intval(noorgfx_get_theme_mod(
		'woo_product_related_cards_rows',
		1
	));

	return $args;
}, 10);

add_filter('woocommerce_upsell_display_args', function ($args) {
	$columns = intval(
		noorgfx_expand_responsive_value(
			noorgfx_get_theme_mod(
				'woo_product_related_cards_columns',
				[
					'desktop' => 4,
					'tablet' => 3,
					'mobile' => 1
				]
			)
		)['desktop']
	);

	$args['columns'] = $columns;
	$args['posts_per_page'] = $columns * intval(noorgfx_get_theme_mod(
		'woo_product_related_cards_rows',
		1
	));

	return $args;
}, 10);

add_filter('woocommerce_upsells_columns', function ($columns) {
	return intval(
		noorgfx_expand_responsive_value(
			noorgfx_get_theme_mod(
				'woo_product_related_cards_columns',
				[
					'desktop' => 4,
					'tablet' => 3,
					'mobile' => 1
				]
			)
		)['desktop']
	);
});

add_filter('comment_class', function ($classes, $class, $comment_id, $comment) {
	if (! noorgfx_manager()->screen->is_product()) {
		return $classes;
	}

	$has_avatar = get_option('show_avatars', 1);

	if ($has_avatar) {
		$classes[] = 'ct-has-avatar';
	}

	return $classes;
}, 10, 4);
