<?php

function noorgfx_has_product_specific_layer($layer_id = '', $args = []) {
	$args = wp_parse_args($args, [
		'respect_post_type' => true
	]);

	if (empty($layer_id)) {
		return false;
	}

	if ($args['respect_post_type']) {
		$post_type = get_post_type();

		if ($post_type !== 'product') {
			return false;
		}
	}

	$default_product_layout = noorgfx_get_woo_single_layout_defaults();

	$layout = noorgfx_get_theme_mod(
		'woo_single_layout',
		$default_product_layout
	);

	$layout = noorgfx_normalize_layout($layout, $default_product_layout);

	$product_view_type = noorgfx_get_product_view_type();

	if (
		$product_view_type === 'top-gallery'
		||
		$product_view_type === 'columns-top-gallery'
	) {
		$woo_single_split_layout = noorgfx_get_theme_mod(
			'woo_single_split_layout',
			[
				'left' => noorgfx_get_woo_single_layout_defaults('left'),
				'right' => noorgfx_get_woo_single_layout_defaults('right')
			]
		);

		$layout = array_merge(
			$woo_single_split_layout['left'],
			$woo_single_split_layout['right']
		);
	}

	$layer_to_find = array_values(array_filter($layout, function($k) use ($layer_id) {
		return $k['id'] === $layer_id;
	}));

	if (empty($layer_to_find)) {
		return false;
	}

	if (
		isset($layer_to_find[0]['enabled'])
		&&
		$layer_to_find[0]['enabled']
	) {
		return true;
	}

	return false;
}
