<?php

if (! function_exists('noorgfx_social_icons')) {
	function noorgfx_social_icons($socials_descriptor = null, $args = []) {
		$args = wp_parse_args(
			$args,
			[
				'icons-color' => 'custom',
				'type' => 'simple',
				'size' => 'custom',
				'fill' => false,
				'label_attr' => [],
				'label_visibility' => [
				  'desktop' => false,
				  'tablet' => false,
				  'mobile' => false,
				],
				'links_target' => false,
				'links_rel' => false,
				'enable_shortcut' => false
			]
		);

		$attr = [
			'data-color' => $args['icons-color']
		];

		if (! empty($args['size'])) {
			$attr['data-icon-size'] = $args['size'];
		}

		// if ($args['type'] !== 'simple') {
			$attr['data-icons-type'] = $args['type'];
		// }

		if ($args['fill']) {
			if ($args['type'] !== 'simple') {
				$attr['data-icons-type'] .= ':' . $args['fill'];
			}
		}

		return noorgfx_get_social_box([
			'attr' => $attr,
			'socials' => $socials_descriptor,
			'label_attr' => $args['label_attr'],
			'label_visibility' => $args['label_visibility'],
			'links_target' => $args['links_target'],
			'links_rel' => $args['links_rel'],
			'enable_shortcut' => $args['enable_shortcut']
		]);
	}
}

/**
 * Get social share box.
 */
if (! function_exists('noorgfx_get_social_share_box')) {
	function noorgfx_get_social_share_box($args = []) {
		$args = wp_parse_args(
			$args,
			[
				'root_class' => '',
				'html_atts' => [],
				'links_wrapper_attr' => [],
				'type' => 'type-1',
				'custom_share_url' => '',
				'strategy' => [
					'strategy' => 'customizer',
					'prefix' => noorgfx_manager()->screen->get_prefix()
				],
				'enable_shortcut' => false
			]
		);

		if (! isset($args['html_atts']['data-type'])) {
			$args['html_atts']['data-type'] = $args['type'];
		}

		$before_content = '';
		$after_content = '';

		$module_title = noorgfx_akg_or_customizer(
			'share_box_title',
			$args['strategy'],
			__('Share your love', 'noorgfx')
		);
		$module_title_tag = noorgfx_akg_or_customizer(
			'share_box_title_tag',
			$args['strategy'],
			'span'
		);

		if (!empty($module_title) || is_customize_preview()) {
			$before_content = noorgfx_html_tag(
				$module_title_tag,
				[
					'class' => 'ct-module-title'
				],
				$module_title
			);
		}

		if ($args['type'] === 'type-1') {
			$args['links_wrapper_attr']['data-icons-type'] = 'simple';
		}

		if ($args['type'] === 'type-2') {
			$args['links_wrapper_attr']['data-icons-type'] = 'custom:solid';
		}

		return noorgfx_get_social_box([
			'type' => 'share',
			'root_class' => trim('ct-share-box' . ' ' . $args['root_class']),
			'class' => noorgfx_visibility_classes(
				noorgfx_akg_or_customizer(
					'share_box_visibility',
					$args['strategy'],
					[
						'desktop' => true,
						'tablet' => true,
						'mobile' => false,
					]
				)
			),
			// 'has_count' => $args['type'] === 'type-2',
			'attr' => $args['html_atts'],
			// 'links_wrapper' => $args['type'] === 'type-1' ? 'div' : null,
			'links_wrapper' => 'div',
			'links_wrapper_attr' => $args['links_wrapper_attr'],
			'before_links_content' => $before_content,
			'after_links_content' => $after_content,
			'custom_share_url' => $args['custom_share_url'],
			'links_rel' => noorgfx_akg_or_customizer(
				'share_links_nofollow',
				$args['strategy'],
				'yes'
			) === 'yes' ? 'noopener noreferrer nofollow' : 'noopener',
			'strategy' => $args['strategy'],
			'enable_shortcut' => $args['enable_shortcut'],
			'has_tooltip' => noorgfx_akg_or_customizer(
				'share_item_tooltip',
				$args['strategy'],
				'no'
			) === 'yes'
		]);
	}
}

if (! function_exists('noorgfx_get_dynamic_social_networks')) {
	function noorgfx_get_dynamic_social_networks() {
		$networks = apply_filters(
			'noorgfx:social-box:dynamic-social-networks',
			[]
		);

		foreach ($networks as $network) {
			noorgfx_assert_args($network, ['id', 'name', 'icon']);
		}

		return $networks;
	}
}

if (! function_exists('noorgfx_get_social_metadata')) {
	function noorgfx_get_social_metadata($args = []) {
		$args = wp_parse_args(
			$args,
			[
				// url | share
				'type' => 'url',
				'custom_url' => '',
				'social' => null,
			]
		);

		$metadata = [
			'facebook' => [
				'name' => 'فیسبوک',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M20,10.1c0-5.5-4.5-10-10-10S0,4.5,0,10.1c0,5,3.7,9.1,8.4,9.9v-7H5.9v-2.9h2.5V7.9C8.4,5.4,9.9,4,12.2,4c1.1,0,2.2,0.2,2.2,0.2v2.5h-1.3c-1.2,0-1.6,0.8-1.6,1.6v1.9h2.8L13.9,13h-2.3v7C16.3,19.2,20,15.1,20,10.1z"/>
					</svg>
				'
			],
			'twitter' => [
				'name' => 'توییتر',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M2.9 0C1.3 0 0 1.3 0 2.9v14.3C0 18.7 1.3 20 2.9 20h14.3c1.6 0 2.9-1.3 2.9-2.9V2.9C20 1.3 18.7 0 17.1 0H2.9zm13.2 3.8L11.5 9l5.5 7.2h-4.3l-3.3-4.4-3.8 4.4H3.4l5-5.7-5.3-6.7h4.4l3 4 3.5-4h2.1zM14.4 15 6.8 5H5.6l7.7 10h1.1z"/>
					</svg>
				'
			],
			'instagram' => [
				'name' => 'اینستاگرام',
				'icon' => '
					<svg
					width="20"
					height="20"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<circle cx="10" cy="10" r="3.3"/>
						<path d="M14.2,0H5.8C2.6,0,0,2.6,0,5.8v8.3C0,17.4,2.6,20,5.8,20h8.3c3.2,0,5.8-2.6,5.8-5.8V5.8C20,2.6,17.4,0,14.2,0zM10,15c-2.8,0-5-2.2-5-5s2.2-5,5-5s5,2.2,5,5S12.8,15,10,15z M15.8,5C15.4,5,15,4.6,15,4.2s0.4-0.8,0.8-0.8s0.8,0.4,0.8,0.8S16.3,5,15.8,5z"/>
					</svg>
				'
			],
			'threads' => [
				'name' => 'تردز',
				'icon' => '
					<svg
					width="20"
					height="20"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M10.7 10.2c.5 0 1 .1 1.5.2-.1 1.1-.5 2.2-1.9 2.3-.6 0-1.1-.1-1.5-.5-.2-.2-.3-.4-.3-.9 0-.3.2-.6.5-.8.5-.2 1-.3 1.7-.3zM20 10c0 4.8 0 7.3-1.4 8.6C17.3 20 14.8 20 10 20s-7.3 0-8.6-1.4C0 17.3 0 14.8 0 10c0-4.9 0-7.3 1.4-8.6C2.7 0 5.1 0 10 0c4.9 0 7.3 0 8.6 1.4C20 2.7 20 5.2 20 10zM6.4 5.2c.9-.9 2.1-1.4 3.8-1.4 3.7 0 4.8 2.6 5 3.7l1.3-.3c-.3-1.1-1.6-4.7-6.3-4.7-2 0-3.5.6-4.7 1.8-1.3 1.4-2 3.5-1.9 6.2.1 4.4 2.6 7 6.5 7 3.3 0 5.7-1.9 5.7-4.5 0-1.7-.8-2.9-2.4-3.6-.2-2.4-1.6-3.3-3-3.4-2.2-.1-3 1.4-3.1 1.5l1.1.6s.5-.9 1.9-.8c.6 0 1.5.3 1.7 1.7-1.4-.3-2.8-.1-3.7.4-.6.4-1 1-1.1 1.7-.1.7.1 1.4.6 1.9.6.6 1.5 1 2.5.9 1.7-.1 2.7-1.3 3-3.1.8.5 1.1 1.1 1.1 2.2 0 1.8-1.9 3.2-4.4 3.2-4.6 0-5.2-4-5.2-5.7 0-1.7.2-3.9 1.6-5.3z"/>
					</svg>
				'
			],
			'pinterest' => [
				'name' => 'پینترست',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M10,0C4.5,0,0,4.5,0,10c0,4.1,2.5,7.6,6,9.2c0-0.7,0-1.5,0.2-2.3c0.2-0.8,1.3-5.4,1.3-5.4s-0.3-0.6-0.3-1.6c0-1.5,0.9-2.6,1.9-2.6c0.9,0,1.3,0.7,1.3,1.5c0,0.9-0.6,2.3-0.9,3.5c-0.3,1.1,0.5,1.9,1.6,1.9c1.9,0,3.2-2.4,3.2-5.3c0-2.2-1.5-3.8-4.2-3.8c-3,0-4.9,2.3-4.9,4.8c0,0.9,0.3,1.5,0.7,2C6,12,6.1,12.1,6,12.4c0,0.2-0.2,0.6-0.2,0.8c-0.1,0.3-0.3,0.3-0.5,0.3c-1.4-0.6-2-2.1-2-3.8c0-2.8,2.4-6.2,7.1-6.2c3.8,0,6.3,2.8,6.3,5.7c0,3.9-2.2,6.9-5.4,6.9c-1.1,0-2.1-0.6-2.4-1.2c0,0-0.6,2.3-0.7,2.7c-0.2,0.8-0.6,1.5-1,2.1C8.1,19.9,9,20,10,20c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0z"/>
					</svg>
				'
			],
			'linkedin' => [
				'name' => 'لینکدین',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M18.6,0H1.4C0.6,0,0,0.6,0,1.4v17.1C0,19.4,0.6,20,1.4,20h17.1c0.8,0,1.4-0.6,1.4-1.4V1.4C20,0.6,19.4,0,18.6,0z M6,17.1h-3V7.6h3L6,17.1L6,17.1zM4.6,6.3c-1,0-1.7-0.8-1.7-1.7s0.8-1.7,1.7-1.7c0.9,0,1.7,0.8,1.7,1.7C6.3,5.5,5.5,6.3,4.6,6.3z M17.2,17.1h-3v-4.6c0-1.1,0-2.5-1.5-2.5c-1.5,0-1.8,1.2-1.8,2.5v4.7h-3V7.6h2.8v1.3h0c0.4-0.8,1.4-1.5,2.8-1.5c3,0,3.6,2,3.6,4.5V17.1z"/>
					</svg>
				'
			],
			'whatsapp' => [
				'name' => 'واتساپ',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M10,0C4.5,0,0,4.5,0,10c0,1.9,0.5,3.6,1.4,5.1L0.1,20l5-1.3C6.5,19.5,8.2,20,10,20c5.5,0,10-4.5,10-10S15.5,0,10,0zM6.6,5.3c0.2,0,0.3,0,0.5,0c0.2,0,0.4,0,0.6,0.4c0.2,0.5,0.7,1.7,0.8,1.8c0.1,0.1,0.1,0.3,0,0.4C8.3,8.2,8.3,8.3,8.1,8.5C8,8.6,7.9,8.8,7.8,8.9C7.7,9,7.5,9.1,7.7,9.4c0.1,0.2,0.6,1.1,1.4,1.7c0.9,0.8,1.7,1.1,2,1.2c0.2,0.1,0.4,0.1,0.5-0.1c0.1-0.2,0.6-0.7,0.8-1c0.2-0.2,0.3-0.2,0.6-0.1c0.2,0.1,1.4,0.7,1.7,0.8s0.4,0.2,0.5,0.3c0.1,0.1,0.1,0.6-0.1,1.2c-0.2,0.6-1.2,1.1-1.7,1.2c-0.5,0-0.9,0.2-3-0.6c-2.5-1-4.1-3.6-4.2-3.7c-0.1-0.2-1-1.3-1-2.6c0-1.2,0.6-1.8,0.9-2.1C6.1,5.4,6.4,5.3,6.6,5.3z"/>
					</svg>
				'
			],
			'telegram' => [
				'name' => 'تلگرام',
				'icon' => '
					<svg
					width="20px"
					height="20px"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M19.9,3.1l-3,14.2c-0.2,1-0.8,1.3-1.7,0.8l-4.6-3.4l-2.2,2.1c-0.2,0.2-0.5,0.5-0.9,0.5l0.3-4.7L16.4,5c0.4-0.3-0.1-0.5-0.6-0.2L5.3,11.4L0.7,10c-1-0.3-1-1,0.2-1.5l17.7-6.8C19.5,1.4,20.2,1.9,19.9,3.1z"/>
					</svg>
				'
			],
			'phone' => [
				'name' => __('تلفن', 'noorgfx'),
				'icon' => '
					<svg
					width="20"
					height="20"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M4.8,0C2.1,0,0,2.1,0,4.8v10.5C0,17.9,2.1,20,4.8,20h10.5c2.6,0,4.8-2.1,4.8-4.8V4.8C20,2.1,17.9,0,15.2,0H4.8z M6.7,3.8C7,3.8,7.2,4,7.4,4.3C7.6,4.6,7.9,5,8.3,5.6c0.3,0.5,0.4,1.2,0.1,1.8l-0.7,1C7.4,8.7,7.4,9,7.5,9.3c0.2,0.5,0.6,1.2,1.3,1.9c0.7,0.7,1.4,1.1,1.9,1.3c0.3,0.1,0.6,0.1,0.9-0.1l1-0.7c0.6-0.3,1.3-0.3,1.8,0.1c0.6,0.4,1.1,0.7,1.3,0.9c0.3,0.2,0.4,0.4,0.4,0.7c0.1,1.7-1.2,2.4-1.6,2.4c-0.3,0-3.4,0.4-7-3.2s-3.2-6.8-3.2-7C4.3,5.1,5,3.8,6.7,3.8z"/>
					</svg>
				'
			],
			'email' => [
				'name' => __('ایمیل', 'noorgfx'),
				'icon' => '
					<svg
					width="20"
					height="20"
					viewBox="0 0 20 20"
					aria-hidden="true">
						<path d="M10,10.1L0,4.7C0.1,3.2,1.4,2,3,2h14c1.6,0,2.9,1.2,3,2.8L10,10.1z M10,11.8c-0.1,0-0.2,0-0.4-0.1L0,6.4V15c0,1.7,1.3,3,3,3h4.9h4.3H17c1.7,0,3-1.3,3-3V6.4l-9.6,5.2C10.2,11.7,10.1,11.7,10,11.8z"/>
					</svg>
				'
			],
			'eitaa' => [
				'name' => __('ایتا', 'noorgfx'),
				'icon' => '
					<svg width="256pt" height="256pt" viewBox="0 0 256 256" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g id="#fffffeff">
					</g>
					<g id="#f5811fff">
					<path fill="#f5811f" opacity="1.00" d=" M 59.31 0.00 L 196.70 0.00 C 211.98 0.89 226.92 7.40 237.69 18.34 C 248.64 29.11 255.11 44.07 256.00 59.36 L 256.00 105.92 C 243.10 111.92 232.87 122.14 222.49 131.61 C 212.97 141.00 203.20 150.11 193.49 159.28 C 180.81 169.77 167.48 180.94 150.94 184.36 C 143.93 185.12 136.46 185.31 129.91 182.31 C 128.47 181.94 126.54 180.37 125.24 181.84 C 119.08 188.33 116.85 197.29 114.27 205.59 C 103.40 201.71 92.74 195.00 87.27 184.49 C 84.10 179.22 83.04 173.02 82.41 167.00 C 82.66 165.53 81.50 164.51 80.49 163.72 C 71.80 157.29 65.57 147.02 65.62 136.03 C 64.99 124.35 70.73 113.53 77.22 104.24 C 92.62 83.76 117.53 71.25 142.98 69.89 C 156.78 69.10 171.61 70.70 183.32 78.65 C 188.12 81.87 192.51 88.12 189.74 94.02 C 185.74 102.99 176.08 107.01 167.78 111.02 C 155.40 116.01 141.99 119.44 128.56 118.17 C 121.76 117.28 114.24 114.28 111.33 107.57 C 109.03 103.42 109.36 98.57 109.62 94.01 C 102.97 94.55 99.71 101.19 96.45 106.12 C 96.49 106.30 96.57 106.66 96.62 106.83 C 93.90 113.90 93.72 121.95 97.15 128.80 C 98.79 131.80 101.12 134.34 103.61 136.64 C 91.88 148.70 89.75 169.37 99.86 183.05 C 102.19 185.22 104.20 188.69 107.69 188.83 C 110.65 181.11 115.79 174.44 121.68 168.72 C 139.27 152.81 162.75 145.88 181.23 131.23 C 199.92 116.97 213.96 94.15 212.21 70.01 C 210.91 57.56 205.67 45.15 196.25 36.68 C 183.60 24.53 164.98 20.48 147.96 22.41 C 129.41 24.03 111.96 32.23 97.08 43.13 C 83.07 53.30 71.18 66.19 61.42 80.46 C 44.52 104.75 35.49 135.03 39.01 164.61 C 40.89 180.89 47.20 196.73 57.63 209.42 C 71.92 226.21 93.61 237.55 115.96 236.42 C 124.98 236.55 133.55 233.49 142.05 230.92 C 163.37 221.60 181.38 205.92 195.51 187.59 C 207.44 172.19 217.72 155.41 231.68 141.69 C 239.34 135.10 247.38 128.91 256.00 123.61 L 256.00 196.72 C 255.10 211.75 248.82 226.47 238.17 237.18 C 227.37 248.40 212.22 255.09 196.71 256.00 L 58.37 256.00 C 43.43 254.77 28.88 248.42 18.34 237.69 C 7.38 226.91 0.88 211.94 0.00 196.63 L 0.00 59.30 C 0.92 43.79 7.59 28.63 18.82 17.83 C 29.54 7.18 44.27 0.89 59.31 0.00 Z" />
					</g>
					</svg>
				'
			],
			'bale' => [
				'name' => __('بله', 'noorgfx'),
				'icon' => '
					<svg width="256pt" height="256pt" viewBox="0 0 256 256" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g id="#0cbc8fff">
					<path fill="#0cbc8f" opacity="1.00" d=" M 0.00 0.00 L 256.00 0.00 L 256.00 256.00 L 0.00 256.00 L 0.00 0.00 M 31.82 41.94 C 31.74 71.29 31.83 100.64 31.78 129.99 C 31.99 163.06 50.83 195.05 79.34 211.68 C 104.81 226.92 137.47 229.45 164.87 217.94 C 188.21 208.49 207.48 189.45 217.26 166.26 C 224.30 150.55 225.98 132.90 224.24 115.90 C 221.08 91.45 208.31 68.38 189.05 52.96 C 172.00 39.08 150.04 31.10 128.00 31.46 C 107.96 31.27 88.20 38.09 71.88 49.58 C 63.42 43.91 55.60 37.23 46.61 32.37 C 40.07 29.02 31.41 34.59 31.82 41.94 Z" />
					<path fill="#0cbc8f" opacity="1.00" d=" M 165.12 84.33 C 170.34 82.78 176.34 82.98 181.08 85.87 C 186.79 89.07 190.64 95.41 190.55 102.00 C 190.97 107.99 187.83 113.58 183.54 117.54 C 165.11 135.77 146.98 154.31 128.55 172.54 C 120.95 180.49 107.05 179.06 100.28 170.72 C 90.31 160.37 79.69 150.62 70.01 140.00 C 65.70 134.22 64.98 125.90 68.52 119.58 C 71.63 113.57 78.18 109.39 85.01 109.58 C 90.16 109.36 95.22 111.53 98.86 115.13 C 104.40 120.50 109.71 126.12 115.26 131.50 C 116.38 130.54 117.50 129.59 118.58 128.59 C 130.60 116.28 142.84 104.18 155.01 92.01 C 157.97 88.99 160.93 85.61 165.12 84.33 Z" />
					</g>
					<g id="#ffffffff">
					</g>
					</svg>
				'
			],
			'rubika' => [
				'name' => __('روبیکا', 'noorgfx'),
				'icon' => '
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 233.5 256"><path d="M126.6,0H128c-.3,9.7-.2,19.4.2,29.1s-.4,20.7.1,31.1l-.5.4-.7.4a13.1,13.1,0,0,0-6.1-4.3c-5.3-1.8-9.8-5.3-14.7-8-8.6-4.2-16.9-9.1-25.1-14.1-3.5-2.2-8-3-10.7-6.4l38.8-22A51.3,51.3,0,0,1,126.6,0Z" transform="translate(-11.2)" style="fill:#b8ce00"/><path d="M128.3,194c8.4,5,16.7,10.3,25.8,14.2,4.8,2.3,8.9,5.9,13.8,8.1s10.2,7.3,16.5,8.5c.2,1.1.4,2.2.5,3.3l-43.6,24.2a36.9,36.9,0,0,1-11.2,3.7h-2.3C128.1,235.3,127.6,214.7,128.3,194Z" transform="translate(-11.2)" style="fill:#b8ce00"/><path d="M128,0h1.7c7.6.9,14.5,4.5,21.1,8.3,12,6.8,24.2,13.6,36.1,20.6h-.8c-5.2,1.7-9.6,4.9-14.4,7.3-14.2,8.5-29,15.9-43.4,23.9-.5-10.4-.5-20.7-.1-31.1S127.7,9.7,128,0Z" transform="translate(-11.2)" style="fill:#7eb525"/><path d="M80.1,221.1c15.7-9.5,32-18,47.4-28l.8.5v.4c-.7,20.7-.2,41.3-.5,62h-.4c-4.8-1-9.7-2-14-4.4L70.2,227.5C73.1,224.8,76.8,223.2,80.1,221.1Z" transform="translate(-11.2)" style="fill:#7eb525"/><path d="M69.8,28.6l.7-.4c2.7,3.4,7.2,4.2,10.7,6.4,8.2,5,16.5,9.9,25.1,14.1,4.9,2.7,9.4,6.2,14.7,8a13.1,13.1,0,0,1,6.1,4.3c-18.3,11.1-37,21.5-55.3,32.7l-1.6-1.4c-.7-4.4-.4-8.9-.3-13.3C70.1,62.2,70.4,45.4,69.8,28.6Z" transform="translate(-11.2)" style="fill:#f6a924"/><path d="M29.7,51.6l40.1-23c.6,16.8.3,33.6.1,50.4-.1,4.4-.4,8.9.3,13.3,0,.2-.1.5-.1.7-3.7-.2-6.9-2.3-10.1-3.9C44.9,81.3,30.8,71.8,15.5,64.4,18.8,58.8,24.1,54.8,29.7,51.6Z" transform="translate(-11.2)" style="fill:#ef7415"/><path d="M186.3,162.3c5.4,2.4,10.9,5,15.7,8.7,2.5,1.9,5.7,2.7,8.3,4.6,6.3,5,14.3,7,21.1,11.2a46.2,46.2,0,0,0,8.4,6.1c-4.9,7.3-13,11.3-20.4,15.6-11,6.3-22,12.7-33.1,18.8C186.1,205.6,186.2,184,186.3,162.3Z" transform="translate(-11.2)" style="fill:#ef7415"/><path d="M186.1,29h.8c13.7,7.6,27.1,15.7,40.7,23.5,5.1,2.9,9.9,6.5,12.9,11.7-7,3.9-14.2,7.5-20.9,12l-.4.3c-7.4,4.1-14.8,8-21.9,12.3-3.6,1.8-7.1,3.7-10.6,5.6l-.5.3C186.4,72.8,186.5,50.9,186.1,29Z" transform="translate(-11.2)" style="fill:#59d6bc"/><path d="M171.7,36.3c4.8-2.4,9.2-5.6,14.4-7.3.4,21.9.3,43.8.1,65.6-19.6-11.2-39-22.7-58.4-34l.5-.4C142.7,52.2,157.5,44.8,171.7,36.3Z" transform="translate(-11.2)" style="fill:#36ad9d"/><path d="M11.3,88c0-8,.5-16.3,4.2-23.6C30.8,71.8,44.9,81.3,60,89.1c3.2,1.6,6.4,3.7,10.1,3.9l-.3,2.1c-11.8,6.1-23.2,13.2-34.9,19.8-4,3-9,4.6-12.8,8s-7.1,3.2-10.4,5.5l-.4-.5C11.2,114.6,11.3,101.3,11.3,88Z" transform="translate(-11.2)" style="fill:#e74b50"/><path d="M219.6,76.1c7-4,14-8.1,21.3-11.8A48.1,48.1,0,0,1,244.7,83c0,15.3.1,30.7,0,46l-.5-.2c-3.8-2-7.3-4.7-11-7s-9.9-5.2-14.6-8.2c-10.6-6.5-21.6-12.3-31.9-19.3,3.5-1.9,7-3.8,10.6-5.6,4.8-.1,8.6-3.5,12.8-5.6s7.3-3,9.1-6.7Z" transform="translate(-11.2)" style="fill:#794487"/><path d="M34.9,114.9c11.7-6.6,23.1-13.7,34.9-19.8,0,22-.2,44,.2,66-4.7-1.8-8.8-4.5-12.9-7.2-11-6-22.1-11.7-32.7-18.3-4.3-2.4-9.1-3.8-12.7-7.2,3.3-2.3,7.1-3.4,10.4-5.5S30.9,117.9,34.9,114.9Z" transform="translate(-11.2)" style="fill:#794487"/><path d="M197.3,88.7c7.1-4.3,14.5-8.2,21.9-12.3-1.8,3.7-6,4.7-9.1,6.7S202.1,88.6,197.3,88.7Z" transform="translate(-11.2)" style="fill:#5c577d"/><path d="M186.2,94.6l.5-.3c10.3,7,21.3,12.8,31.9,19.3,4.7,3,9.8,5.3,14.6,8.2s7.2,5,11,7c-14.6,8.2-29.2,16.5-43.9,24.4a114.8,114.8,0,0,1-14.2,7.7C186.4,138.8,186,116.7,186.2,94.6Z" transform="translate(-11.2)" style="fill:#4c3684"/><path d="M11.3,127.9l.4.5c3.6,3.4,8.4,4.8,12.7,7.2,10.6,6.6,21.7,12.3,32.7,18.3,4.1,2.7,8.2,5.4,12.9,7.2l-.3.2c-17.8,10.4-36,20.3-53.3,31.6-4.4-7.1-5-15.8-5.2-23.9C11.3,155.3,11.2,141.6,11.3,127.9Z" transform="translate(-11.2)" style="fill:#4c3784"/><path d="M200.3,153.2c14.7-7.9,29.3-16.2,43.9-24.4l.5.2v44c-.1,6.9-1.2,14-4.9,19.9a46.2,46.2,0,0,1-8.4-6.1c-6.8-4.2-14.8-6.2-21.1-11.2-2.6-1.9-5.8-2.7-8.3-4.6-4.8-3.7-10.3-6.3-15.7-8.7-.1-.2-.1-.8-.2-1.1v-.3A114.8,114.8,0,0,0,200.3,153.2Z" transform="translate(-11.2)" style="fill:#e74c50"/><path d="M173.1,168.2c4.4-2.2,8.5-5.1,13-7,.1.3.1.9.2,1.1-.1,21.7-.2,43.3,0,65l-1.4.8c-.1-1.1-.3-2.2-.5-3.3-6.3-1.2-10.8-5.9-16.5-8.5s-9-5.8-13.8-8.1c-9.1-3.9-17.4-9.2-25.8-14.2v-1.1C143.3,184.9,158,176.2,173.1,168.2Z" transform="translate(-11.2)" style="fill:#f6aa24"/><path d="M16.4,192.9c17.3-11.3,35.5-21.2,53.3-31.6.1,22,.1,43.9.1,65.9-12.6-7-25.1-14.2-37.6-21.4C26.3,202.4,20.4,198.6,16.4,192.9Z" transform="translate(-11.2)" style="fill:#0f68a0"/><path d="M69.7,161.3c5.7,2.4,10.9,5.9,16.4,8.7,13.7,7.8,27.7,15.2,41.4,23.1-15.4,10-31.7,18.5-47.4,28-3.3,2.1-7,3.7-9.9,6.4l-.4-.3C69.8,205.2,69.8,183.3,69.7,161.3Z" transform="translate(-11.2)" style="fill:#49bdca"/></svg>
				'
			],
			'aparat' => [
				'name' => __('آپارات', 'noorgfx'),
				'icon' => '
					<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						 viewBox="0 0 256 256" style="enable-background:new 0 0 256 256;" xml:space="preserve">
					<style type="text/css">
						.st0{fill:#ED145B;}
					</style>
					<g id="_x23_ffffffff">
					</g>
					<g id="_x23_e4e4e4ff">
					</g>
					<g id="_x23_f1f1f1ff">
					</g>
					<g id="_x23_ed145bff">
						<path class="st0" d="M114.4,4.8c23.5-2.5,47.6,1.6,68.8,12c23.4,11.4,43.1,30.2,55.3,53.1c12.6,23.3,17.2,50.8,13.1,77
							c-3.7,24.3-15,47.3-31.8,65.2c-17,18.2-39.5,31.2-63.8,36.7c-24.5,5.6-50.6,3.7-74-5.5c-23.4-9.1-44-25.5-58-46.3
							C7.7,173.1,0.4,143.4,3.6,114.7c2.2-21.2,10.2-41.8,22.7-59C46.8,27.3,79.6,8.4,114.4,4.8 M86.5,37.7C79,38.9,72,42.5,66.7,47.9
							c-7.2,7.2-11,17.5-10.1,27.6c0.8,9.7,5.8,19,13.6,25c8.6,6.7,20.4,9.2,31,6.4c14.8-3.6,26.4-17.5,26.7-32.7
							c0.7-12-5.4-24-15.4-30.7C105,38.3,95.5,36.2,86.5,37.7 M174.6,55.1c-6.9,1.4-13.4,5-18.3,10.1c-6.5,6.6-10.2,15.8-9.9,25
							c0,10.6,5.3,21,13.8,27.5c6.2,4.8,14,7.5,21.8,7.4c9.5,0.2,19-3.8,25.6-10.6c7.9-7.8,11.6-19.6,9.7-30.5c-1.5-9-6.7-17.4-14.1-22.7
							C195.1,55.3,184.4,52.9,174.6,55.1 M122.7,113.8c-6.9,1.9-11.9,9.1-11.2,16.2c0.4,8,7.8,14.7,15.8,14.5c7.7,0.2,14.9-6,15.8-13.7
							c0.7-5.3-1.6-10.9-5.8-14.3C133.3,113.4,127.6,112.3,122.7,113.8 M68.2,131.3c-7.4,1.3-14.5,4.8-19.7,10.2
							c-7.8,7.8-11.6,19.5-9.7,30.4c1.4,9.1,6.6,17.4,14.1,22.8c8.4,6.2,19.6,8.5,29.8,5.9c10.8-2.6,20.2-10.5,24.4-20.8
							c2.6-6,3.2-12.6,2.3-19c-1.6-10-7.7-19.2-16.3-24.5C85.7,131.7,76.7,130,68.2,131.3 M156.3,148.8c-10.6,2.2-20,9.4-24.7,19.2
							c-3.3,6.7-4.2,14.4-3,21.8c1.7,9.2,7.2,17.6,14.9,22.8c8.6,6,20,7.8,30,4.9c8.8-2.5,16.6-8.5,21.2-16.4c4-7,5.7-15.4,4.3-23.3
							c-1.4-9-6.6-17.4-14-22.8C176.9,149,166.2,146.6,156.3,148.8z"/>
					</g>
					</svg>
				'
			],
			'igap' => [
				'name' => __('آی گپ', 'noorgfx'),
				'icon' => '
					<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						 viewBox="0 0 1080 1080" style="enable-background:new 0 0 1080 1080;" xml:space="preserve">
					<style type="text/css">
						.st0{fill:#8ECA5F;}
					</style>
					<g id="_x23_8eca5fff">
						<path class="st0" d="M446,27.7c79.6-18,164.3-13.3,241,14.8c112.8,39.7,207.1,128.7,253.3,239c20.8,49.7,33.7,103.5,32.5,157.6
							c0,22.9,0.9,45.8-2.1,68.5c-2.3,17.1-5.6,34.2-9.8,50.9c-1.4,5.6-3.6,11.1-3.7,17c-1.2,2-2.4,4-3.1,6.3
							c-18.1,56.9-48.2,109.9-87.8,154.6c-14.1,15.4-29.1,29.9-43.8,44.7c-93.7,93.7-187.6,187.3-281.3,280.9
							c-0.8-45.5-0.2-91.1-0.3-136.7c-0.4-3.5,1.6-8.3-2.4-10.1c3.9-10.2,1.7-21.2,2.1-31.8c-71.3-0.4-142.3-18.4-205.4-51.7
							c-44.9-24.7-86-56.8-119.9-95.3c-33.6-37.8-59.7-81.9-78.8-128.7c-29.4-76.3-37.1-160.9-21.2-241.2
							C131,285.7,170.7,209.7,228,150.5C286.6,89.4,363.2,45.7,446,27.7 M530.1,165.1C475,220.3,419.7,275.4,364.6,330.6
							c-24.2,26.7-42.4,58.9-51.7,93.8c-0.8,3.2-1.6,6.4-3.1,9.4c-0.3,3-0.3,6.2-1.8,9c-1.1,7.8-2.3,15.6-3.9,23.3
							c-0.5,15.1-0.2,30.3-0.1,45.4c1.5,9,2.6,18,4.1,27c1.7,4.7,2.7,9.6,3.5,14.5c11.7,37.9,30.8,74.2,59.2,102.2
							c21.4,22.3,47.5,39.8,75.7,52.3c12,2.8,23.4,7.7,35.3,10.6c37.7,9.8,78,10.1,115.8,0.6c13.1-3.2,25.7-8,38.8-11.5
							c14.2-7,28.3-14.2,41.1-23.6c41.2-28.4,71.9-70.8,88.2-118c1.5-4.2,2.3-8.6,4.4-12.5c0.6-7.2,3.5-13.9,4.3-21
							c1.8-6.1,1.2-12.6,3.1-18.6c0.3-14.5,0.2-29.1,0.1-43.6c-1.4-9-2.8-18-4-27.1c-1.6-2.8-1.5-6-1.8-9c-3.7-8.9-5.1-18.7-9-27.5
							c-9.8-26.1-24.3-50.5-42.9-71.3c-7.1-9-15.4-17.1-24.4-24.3c-34.7-30.9-79.3-50.1-125.2-55.6c-5.9-2.2-12.2-0.2-18-2.2
							c-3.8-1.2-7.7-0.8-11.5-0.7c-0.2-31.8,0.6-63.7-0.5-95.5C536.1,158.2,533.3,162,530.1,165.1z"/>
					</g>
					<g id="_x23_f6faf2ff">
					</g>
					</svg>
				'
			],
		];

		foreach (noorgfx_get_dynamic_social_networks() as $dynamic_network) {
			$metadata[$dynamic_network['id']] = [
				'name' => $dynamic_network['name'],
				'icon' => $dynamic_network['icon']
			];
		}

		if (! $args['social']) {
			return null;
		}

		if (! isset($metadata[$args['social']])) {
			return null;
		}

		$single_metadata = $metadata[$args['social']];
		$single_metadata['url'] = '';

		if ($args['type'] === 'url') {
			$single_metadata['url'] = noorgfx_get_theme_mod($args['social'], '#');

			if (empty(trim($single_metadata['url']))) {
				$single_metadata['url'] = '#';
			}

			if (
				$args['social'] === 'email'
				&&
				strpos($single_metadata['url'], 'mailto:') === false
				&&
				strpos($single_metadata['url'], '@') !== false
			) {
				$single_metadata['url'] = 'mailto:' . $single_metadata['url'];
			}
		}

		if ($args['type'] === 'share') {
			$home_url = noorgfx_encode_uri_component(
				get_the_permalink()
			);

			if (! empty($args['custom_url'])) {
				$home_url = noorgfx_encode_uri_component($args['custom_url']);
			}

			$social_urls = [
				'eitaa' => 'https://eitaa.com/share/url?url={url}&text={text}',
				'bale' => 'https://ble.ir/share?url={url}&text={text}',
				'rubika' => 'https://rubika.ir/share?url={url}&text={text}',
				'igap' => 'https://igap.net/share?url={url}&text={text}',			
				'facebook' => 'https://www.facebook.com/sharer/sharer.php?u={url}',
				'twitter' => 'https://twitter.com/intent/tweet?url={url}&text={text}',
				'linkedin' => 'https://www.linkedin.com/shareArticle?url={url}&title={text}',
				'telegram' => 'https://t.me/share/url?url={url}&text={text}',
				'whatsapp' => 'whatsapp://send?text={url}',
				'email' => 'mailto:?subject={text}&body={url}',
				'clipboard' => '#'

			];

			if (! empty($args['custom_url'])) {
				$social_urls['clipboard'] = $args['custom_url'];
			}

			if (isset($social_urls[$args['social']])) {
				$single_metadata['url'] = str_replace(
					'{url}',
					$home_url,
					str_replace(
						'{text}',
						noorgfx_encode_uri_component(
							strip_tags(get_the_title())
						),
						$social_urls[$args['social']]
					)
				);
			} else {
				$single_metadata['url'] = '#';
			}
		}

		return $single_metadata;
	}
}


if (! function_exists('noorgfx_get_social_box')) {
function noorgfx_get_social_box($args = []) {
	$args = wp_parse_args(
		$args,
		[
			// url | share
			'type' => 'url',
			'socials' => null,
			'attr' => [],
			'class' => '',
			'before_links_content' => '',

			'links_wrapper' => null,
			'links_wrapper_attr' => [],

			'after_links_content' => '',
			'has_count' => false,
			'label_attr' => [],
			'label_visibility' => [
				'desktop' => false,
				'tablet' => false,
				'mobile' => false,
			],
			'root_class' => 'ct-social-box',
			'force_output' => false,
			'custom_share_url' => '',

			'links_target' => false,
			'links_rel' => false,
			'icon_source' => 'default',
			'url_source' => 'default',
			'icon' => '',
			'custom_url' => '',
			'strategy' => [
				'prefix' => noorgfx_manager()->screen->get_prefix(),
				'strategy' => 'customizer'
			],
			'enable_shortcut' => false,

			'has_tooltip' => false,
		]
	);

	if ($args['type'] === 'share') {
		$args['socials'] = noorgfx_akg_or_customizer(
			'share_networks',
			$args['strategy'],
			[
				[
					'id' => 'facebook',
					'enabled' => true,
				],
				[
					'id' => 'twitter',
					'enabled' => true,
				],
				[
					'id' => 'pinterest',
					'enabled' => true,
				],
				[
					'id' => 'linkedin',
					'enabled' => true,
				]
			]
		);
	}

	if ($args['socials'] === null) {
		$args['socials'] = [];

		foreach (noorgfx_get_social_networks_list() as $network_id => $network) {
			$args['socials'][] = [
				'id' => $network_id,
				'enabled' => true
			];
		}
	}

	$has_any_social = 0;

	foreach ($args['socials'] as $single_social) {
		if (
			! isset($single_social['enabled'])
			|| (
				isset($single_social['enabled'])
				&&
				$single_social['enabled']
			) || $args['force_output']
		) {
			$has_any_social++;
		}
	}

	if (! $has_any_social) {
		return '';
	}

	$old_attr = [];

	$old_attr['class'] = $args['root_class'];

	if (! empty($args['class'])) {
		$old_attr['class'] .= ' ' . $args['class'];
	}

	if ($args['type'] === 'share') {
		// $old_attr['data-behavior'] = 'share';
	}

	if ($args['has_count']) {
		$old_attr['data-count'] = $has_any_social;
	}

	$old_attr = array_merge($old_attr, $args['attr']);

	$official_colors = [
		'facebook' => '#557dbc',
		'twitter' => '#000000',
		'instagram' => '#ed1376',
		'threads' => '#101010',
		'pinterest' => '#ea575a',
		'linkedin' => '#1c86c6',
		'whatsapp' => '#5bba67',
		'telegram' => '#229cce',
		'phone' => '#244371',
		'email' => '#392c44',
	];

	$prefix = noorgfx_manager()->screen->get_prefix();

	$deep_link_args = [
		'prefix' => $prefix,
		'suffix' => $prefix . '_has_share_box'
	];

	ob_start();

	?>

		<div <?php echo noorgfx_attr_to_html($old_attr) ?> <?php echo $args['enable_shortcut'] ? noorgfx_generic_get_deep_link($deep_link_args) : ''; ?>>
			<?php echo $args['before_links_content'] ?>

			<?php
				if ($args['links_wrapper']) {
					$result = $args['links_wrapper'];

					$result = trim($result . ' ' . noorgfx_attr_to_html(
						$args['links_wrapper_attr']
					));

					echo '<' . $result . '>';
				}
			?>

			<?php foreach ($args['socials'] as $single_social) { ?>
				<?php
					if (! $single_social['enabled'] && !$args['force_output']) {
						continue;
					}

					$metadata = noorgfx_get_social_metadata([
						'type' => $args['type'],
						'social' => $single_social['id'],
						'custom_url' => $args['custom_share_url']
					]);

					if (! $metadata) {
						continue;
					}

					$attr = [
						'href' => esc_url_raw(
							$metadata['url'],
							array_merge(
								wp_allowed_protocols(),
								[
									'viber',
									'whatsapp',
									'skype'
								]
							)
						),
						// 'target' => '_blank',
						'data-network' => $single_social['id'],
						'aria-label' => $metadata['name']
					];

					if (strpos($attr['href'], 'mailto:') !== false) {
						$attr['href'] = noorgfx_safe_antispambot($attr['href']);
					}

					$url_source = noorgfx_default_akg('url_source', $single_social, 'default');

					if ($url_source === 'custom') {
						$url = noorgfx_default_akg(
							'custom_url',
							$single_social,
							''
						);

						$attr['href'] = esc_url($url);
					}

					if (empty($attr['href'])) {
						$attr['href'] = '#';
					}

					if (
						(
							(
								isset($args['links_wrapper_attr']['data-color'])
								&&
								$args['links_wrapper_attr']['data-color'] === 'official'
							) || (
								isset($old_attr['data-color'])
								&&
								$old_attr['data-color'] === 'official'
							)
						)
						&&
						isset($official_colors[$single_social['id']])
					) {
						$attr['style'] = "--official-color: " . $official_colors[
							$single_social['id']
						];
					}

					if ($args['links_target']) {
						$attr['target'] = $args['links_target'];
					}

					if ($args['links_rel']) {
						$attr['rel'] = $args['links_rel'];
					}

					if (isset($attr['rel'])) {
						$attr['rel'] = trim($attr['rel']);
					}

					$class = 'ct-label';

					if (isset($args['label_attr']['class'])) {
						if (! empty($args['label_attr']['class'])) {
							$class .= ' ' . $args['label_attr']['class'];
						}
					}

					$class .= ' ' . noorgfx_visibility_classes(
						$args['label_visibility']
					);

					$label_attr = $args['label_attr'];

					$label_attr['class'] = $class;
					$label_attr['aria-hidden'] = 'true';
				?>

				<a <?php echo noorgfx_attr_to_html($attr) ?>>
					<?php
						// if ($args['type'] === 'share') {
						// 	echo $metadata['icon'];
						// }

						if (true || $args['type'] === 'url') {
							$icon = noorgfx_html_tag(
								'span',
								[
									'class' => 'ct-icon-container'
								],
								$metadata['icon']
							);

							if (function_exists('blc_get_icon')) {
								$icon_source = noorgfx_default_akg('icon_source', $single_social, 'default');

								if ( $icon_source === 'custom' ) {
									$icon = blc_get_icon([
										'icon_descriptor' => noorgfx_akg(
											'icon',
											$single_social,
											['icon' => 'blc blc-email']
										),
										'icon_html_atts' => [
											'aria-hidden' => 'true',
										]
									]);
								}

							}

							if ($args['has_tooltip']) {
								$share_text = noorgfx_safe_sprintf(
									__('Share on %s', 'noorgfx'),
									$metadata['name']
								);

								if ($single_social['id'] === 'clipboard') {
									$share_text = __('Copy to Clipboard', 'noorgfx');
								}

								echo noorgfx_html_tag(
									'span',
									[
										'class' => 'ct-tooltip'
									],
									$share_text
								);
							}

							echo $icon;

							if ($args['type'] === 'url') {
								if (
									noorgfx_some_device($args['label_visibility'])
									||
									is_customize_preview()
								) {
									echo noorgfx_html_tag(
										'span',
										$label_attr,
										$metadata['name']
									);
								}
							}
						}
					?>
				</a>
			<?php } ?>

			<?php
				if ($args['links_wrapper']) {
					echo '</' . $args['links_wrapper'] . '>';
				}
			?>

			<?php echo $args['after_links_content'] ?>
		</div>

	<?php

	return ob_get_clean();
}
}

/**
 * Encore a string to be safely included in the URL.
 *
 * @param string $str String to encode for URL.
 */
if (! function_exists('noorgfx_encode_uri_component')) {
	function noorgfx_encode_uri_component( $str ) {
		$revert = [
			'%21' => '!',
			'%2A' => '*',
			'%27' => "'",
			'%28' => '(',
			'%29' => ')',
		];

		return strtr( rawurlencode( $str ), $revert );
	}
}

if (! function_exists('noorgfx_get_social_networks_list')) {
	function noorgfx_get_social_networks_list() {
		$networks = [
			'email' => [
				'label' => __( 'ایمیل', 'noorgfx' ),
			],

			'facebook' => [
				'label' => 'فیسبوک',
			],

			'instagram' => [
				'label' => 'اینستاگرام',
			],

			'threads' => [
				'label' => 'تردز',
			],

			'linkedin' => [
				'label' => 'لینکدین',
			],

			'phone' => [
				'label' => __( 'تلفن', 'noorgfx' ),
			],

			'pinterest' => [
				'label' => 'پینترست',
			],

			'telegram' => [
				'label' => 'تلگرام',
			],

			'twitter' => [
				'label' => 'X (توییتر)',
			],

			'whatsapp' => [
				'label' => 'واتساپ',
			],
		];

		$dynamic_networks = noorgfx_get_dynamic_social_networks();

		foreach ($dynamic_networks as $network) {
			$networks[$network['id']] = [
				'label' => $network['name']
			];
		}

		return $networks;
	}
}
