<?php

if (! function_exists('noorgfx_is_page_title_default')) {
	function noorgfx_is_page_title_default() {
		if (noorgfx_is_page() || is_single()) {
			$post_options = noorgfx_get_post_options();

			$mode = noorgfx_akg('has_hero_section', $post_options, 'default');

			if ($mode !== 'default') {
				return false;
			}
		}

		return true;
	}
}

if (! function_exists('noorgfx_get_page_title_source')) {
	function noorgfx_get_page_title_source() {
		static $result = null;

		if (! is_null($result)) {
			if (! is_customize_preview()) {
				return $result;
			}
		}

		$maybe_custom_source = apply_filters(
			'noorgfx:hero:custom-source',
			null
		);

		if ($maybe_custom_source !== null) {
			$result = $maybe_custom_source;
			return $result;
		}

		$prefix = noorgfx_manager()->screen->get_prefix();

		if ($prefix === 'ct_content_block_single') {
			$result = false;
			return $result;
		}

		if ($prefix === 'ct_product_tab_single') {
			$result = false;
			return $result;
		}

		if ($prefix === 'ct_size_guide_single') {
			$result = false;
			return $result;
		}

		if ($prefix === 'ct_thank_you_page_single') {
			$result = false;
			return $result;
		}

		if ($prefix === 'jet-woo-builder_single') {
			$result = false;
			return $result;
		}

		if ($prefix && strpos($prefix, 'single') !== false || (
			function_exists('is_shop') && is_shop()
		) && ! is_search()) {
			$post_options = noorgfx_get_post_options();

			$mode = noorgfx_akg('has_hero_section', $post_options, 'default');

			if ($mode === 'disabled') {
				$result = false;
				return $result;
			}

			if ($mode === 'enabled')  {
				$result = [
					'strategy' => $post_options
				];
				return $result;
			}
		}

		$default_value = 'yes';

		if (
			$prefix === 'blog'
			||
			$prefix === 'tribe_events_single'
		) {
			$default_value = 'no';
		}

		if (noorgfx_get_theme_mod($prefix . '_hero_enabled', $default_value) === 'no') {
			$result = false;
			return $result;
		}

		$result = [
			'strategy' => 'customizer',
			'prefix' => $prefix
		];

		return $result;
	}
}

if (! function_exists('noorgfx_first_level_deep_link')) {
	function noorgfx_first_level_deep_link($prefix) {
		if ($prefix === 'blog') {
			return 'blog_posts';
		}

		if ($prefix === 'author') {
			return 'author_page';
		}

		if ($prefix === 'search') {
			return 'search_page';
		}

		if ($prefix === 'woo_categories') {
			return 'woocommerce_posts_archives';
		}

		if ($prefix === 'categories') {
			return 'archive_blog_posts_categories';
		}

		if ($prefix === 'single_page') {
			return 'single_pages';
		}

		if ($prefix === 'single_blog_post') {
			return 'single_blog_posts';
		}

		if ($prefix === 'product') {
			return 'woocommerce_single';
		}

		if ($prefix && strpos($prefix, '_archive') !== false) {
			return 'post_type_archive_' . str_replace(
				'_archive', '', $prefix
			);
		}

		if ($prefix && strpos($prefix, '_single') !== false) {
			return 'post_type_single_' . str_replace(
				'_single', '', $prefix
			);
		}

		return null;
	}
}

if (! function_exists('noorgfx_hero_get_deep_link')) {
	function noorgfx_hero_get_deep_link($source) {
		if (! $source) {
			return null;
		}

		if (! isset($source['prefix'])) {
			return null;
		}

		$first_level = noorgfx_first_level_deep_link($source['prefix']);

		if (! $first_level) {
			return null;
		}

		return $first_level . ':' . $source['prefix'] . '_hero_enabled';
	}
}

if (! function_exists('noorgfx_output_hero_section')) {
	function noorgfx_output_hero_section($args = []) {
		$args = wp_parse_args($args, [
			'type' => 'type-1',
			'source' => false,
			'elements' => null
		]);

		$type = $args['type'];

		if (! noorgfx_get_page_title_source()) {
			return '';
		}

		$default_type = 'type-1';

		if (
			noorgfx_get_page_title_source()['strategy'] === 'customizer'
			&& (
				noorgfx_get_page_title_source()['prefix'] === 'woo_categories'
				||
				noorgfx_get_page_title_source()['prefix'] === 'author'
			)
		) {
			$default_type = 'type-2';
		}

		$actual_type = noorgfx_akg_or_customizer(
			'hero_section',
			noorgfx_get_page_title_source(),
			$default_type
		);

		if (! $type) {
			$type = $actual_type;
		}

		if ($type !== $actual_type) {
			return '';
		}

		$post_id = noorgfx_get_special_post_id();

		$elements = $args['elements'];

		if (! $elements) {
			$elements = noorgfx_render_view(
				dirname(__FILE__) . '/hero/elements.php',
				[
					'type' => $type,
					'post_id' => $post_id
				]
			);
		}

		if ($type !== 'type-1' && $type !== 'type-2') {
			return '';
		}

		ob_start();

		do_action('noorgfx:hero:before', $type);

		$attr = [
			'class' => 'hero-section',
			'data-type' => $type
		];

		if ($type === 'type-1') {
			$attr['class'] .= ' is-width-constrained';
		}

		if (
			is_customize_preview()
			&&
			noorgfx_is_page_title_default()
			&&
			noorgfx_hero_get_deep_link(noorgfx_get_page_title_source())
		) {
			$attr['data-shortcut'] = 'border';
			$attr['data-shortcut-location'] = noorgfx_hero_get_deep_link(noorgfx_get_page_title_source());
		}

		echo noorgfx_render_view(
			dirname(__FILE__) . '/hero/' . $type . '.php',
			[
				'type' => $type,
				'elements' => $elements,
				'attr' => $attr,
				'post_id' => $post_id,
			]
		);

		do_action('noorgfx:hero:after', $type);

		return ob_get_clean();
	}
}

