<?php

namespace Noorgfx;

class LegacyWidgetsContactInfoTransformer {
	private $data = [];

	public function __construct($data) {
		$this->data = $data;
	}

	public function get_block() {
		$options = noorgfx_akg('ct_options', $this->data, []);

		$sizes = [
			'small' => 15,
			'medium' => 20,
			'large' => 25,
		];

		$old_size = noorgfx_akg('contacts_icons_size', $options, 'medium');

		if (isset($sizes[$old_size])) {
			$options['contacts_icons_size'] = $sizes[$old_size];
		}

		$options = array_merge(
			[
				'title' => __('Contact Info', 'noorgfx'),
				'contact_text' => '',
				'contact_information' => [
					[
						'id' => 'address',
						'enabled' => true,
						'title' => __('Address:', 'noorgfx'),
						'content' => 'خیابان یکم پلاک دوم',
						'link' => '',
					],

					[
						'id' => 'phone',
						'enabled' => true,
						'title' => __('Phone:', 'noorgfx'),
						'content' => '021-12345678',
						'link' => 'tel:021-12345678',
					],

					[
						'id' => 'mobile',
						'enabled' => true,
						'title' => __('Mobile:', 'noorgfx'),
						'content' => '021-12345678',
						'link' => 'tel:021-12345678',
					],
				],
				'contact_link_target' => 'no',
				'link_icons' => 'no',
				'contacts_icons_size' => 20,
				'contacts_items_spacing' => '',
				'contacts_icon_shape' => 'rounded',
				'contacts_icon_fill_type' => 'outline',
				'contacts_items_direction' => 'column',
			],
			$options
		);

		$innerContent = [
			'<h3 class="widget-title">',
			$options['title'],
			'</h3>'
		];

		$innerBlocks = [
			[
				'blockName' => 'core/heading',
				'attrs' => [
					'level' => 3,
					'fontSize' => 'medium',
					'className' => 'widget-title',
				],
				'innerBlocks' => [],
				'innerHTML' => join('', $innerContent),
				'innerContent' => $innerContent
			]
		];

		if (! empty($options['contact_text'])) {
			$innerBlocks[] = [
				'blockName' => 'core/paragraph',
				'attrs' => [
					'placeholder' => 'Description',
				],
				'innerBlocks' => [],
				'innerHTML' => '<p>' . $options['contact_text'] . '</p>',
				'innerContent' => [
					'<p>',
					$options['contact_text'],
					'</p>'
				]
			];
		}

		$innerBlocks[] = [
			'blockName' => 'noorgfx/contact-info',
			'attrs' => array_merge(
				[
					'lock' => [
						'remove' => true
					]
				],
				$options
			),
			'innerBlocks' => [],
			'innerHTML' => '<div>Noorgfx: Contact Info</div>',
			'innerContent' => [
				'<div>Noorgfx: Contact Info</div>'
			]
		];

		$blocks = [
			[
				'blockName' => 'noorgfx/widgets-wrapper',
				'attrs' => [
					'heading' => 'Contact Info',
					'block' => 'noorgfx/contact-info',
					'hasDescription' => true,
					'description' => $options['contact_text'],
				],
				'innerBlocks' => $innerBlocks,
				'innerHTML' => '',
				'innerContent' => [null, null, null],
				'firstLevelBlock' => true
			]
		];

		return serialize_blocks($blocks);
	}
}

