<?php

namespace Noorgfx;

class BlocksFallback {
	public function __construct() {
		add_filter(
			'render_block',
			[$this, 'render_block'],
			10,
			3
		);
	}

	public function render_block($content, $block, $render) {
		if (! isset($block['blockName'])) {
			return $content;
		}

		if (strpos($block['blockName'], 'noorgfx/') !== 0) {
			return $content;
		}

		$blockRegistry = \WP_Block_Type_Registry::get_instance();

		if ($blockRegistry->is_registered($block['blockName'])) {
			return $content;
		}

		if (! current_user_can('manage_options')) {
			return '';
		}

		$block_names_map = [
			'noorgfx/about-me' => __('About Me', 'noorgfx'),
			'noorgfx/breadcrumbs' => __('Breadcrumbs', 'noorgfx'),
			'noorgfx/contact-info' => __('Contact Info', 'noorgfx'),
			'noorgfx/query' => __('Advanced Posts', 'noorgfx'),
			'noorgfx/search' => __('Advanced Search', 'noorgfx'),
			'noorgfx/share-box' => __('Share Box', 'noorgfx'),
			'noorgfx/socials' => __('Socials', 'noorgfx'),
			'noorgfx/dynamic-data' => __('Dynamic Data', 'noorgfx'),
		];

		$block_name = $block['blockName'];

		if ($block_name === 'noorgfx/widgets-wrapper') {
			if (
				isset($block['attrs'])
				&&
				isset($block['attrs']['block'])
			) {
				$block_name = $block['attrs']['block'];
			} else {
				foreach ($block['innerBlocks'] as $inner_block) {
					if (
						isset($inner_block['blockName'])
						&&
						strpos($inner_block['blockName'], 'noorgfx/') === 0
					) {
						$block_name = $inner_block['blockName'];
						break;
					}
				}
			}
		}

		if (! isset($block_names_map[$block_name])) {
			return $content;
		}

		return noorgfx_html_tag(
			'div',
			[],
			sprintf(
				__('The %s block is moved to the Noorgfx Component plugin. Please install this plugin to get access to the block.', 'noorgfx'),
				$block_names_map[$block_name]
			)
		);
	}
}
