<?php

namespace Noorgfx\DbVersioning;

class V2110 {
	public function migrate() {
		if (
			! function_exists('wc_get_attribute_taxonomies')
			||
			! class_exists('\Noorgfx\Plugin')
			||
			! in_array(
				'woocommerce-extra',
				get_option('noorgfx_active_extensions', [])
			)
		) {
			return;
		}

		if (! class_exists('\Noorgfx\Extensions\WoocommerceExtra\Storage')) {
			return;
		}

		$storage = new \Noorgfx\Extensions\WoocommerceExtra\Storage();
		$settings = $storage->get_settings();

		if (
			! isset($settings['features']['free-shipping'])
			||
			! $settings['features']['free-shipping']
		) {
			return;
		}

		$woo_count_with_discount = get_theme_mod(
			'woo_count_with_discount',
			'__empty__'
		);

		if ($woo_count_with_discount === '__empty__') {
			return;
		}

		if ($woo_count_with_discount === 'exclude') {
			set_theme_mod('woo_count_with_discount', 'no');
		} else {
			set_theme_mod('woo_count_with_discount', 'yes');
		}
		
	}
}


