<?php

noorgfx_add_early_inline_style_in_gutenberg(function () {
	$m = new \Noorgfx\FontsManager();
	$maybe_google_fonts_url = $m->load_editor_fonts();

	if (! empty($maybe_google_fonts_url)) {
		return "@import url('" . $maybe_google_fonts_url . "');\n";
	}

	return '';
});

add_action(
	'enqueue_block_editor_assets',
	function () {
		if (get_current_screen()->base === 'widgets') {
			return;
		}

		$theme = noorgfx_get_wp_parent_theme();
		global $post;

		$options = noorgfx_get_options('meta/' . get_post_type($post));

		if (
			$post
			&&
			intval(get_option('page_for_posts')) === intval($post->ID)
		) {
			$options = noorgfx_get_options('meta/blog');
		}

		if (
			$post
			&&
			intval(get_option('woocommerce_shop_page_id')) === $post->ID
		) {
			$options = noorgfx_get_options('meta/blog');
		}

		if (noorgfx_manager()->post_types->is_supported_post_type()) {
			$options = noorgfx_get_options('meta/default', [
				'post_type' => get_post_type_object(get_post_type($post))
			]);
		}

		$options = apply_filters(
			'noorgfx:editor:post_meta_options',
			$options,
			get_post_type($post)
		);

		wp_enqueue_style(
			'ct-main-editor-styles',
			get_template_directory_uri() . '/static/bundle/editor.min.css',
			[],
			$theme->get('Version')
		);

		if (get_current_screen()->base === 'post') {
			wp_enqueue_style(
				'ct-main-editor-iframe-styles',
				get_template_directory_uri() . '/static/bundle/editor-iframe.min.css',
				[],
				$theme->get('Version')
			);

			wp_add_inline_style(
				'ct-main-editor-styles',
				noorgfx_manager()->dynamic_css->load_backend_dynamic_css([
					'echo' => false,
					'filename' => 'admin/editor-top-level'
				])
			);
		}

		if (is_rtl()) {
			wp_enqueue_style(
				'ct-main-editor-rtl-styles',
				get_template_directory_uri() . '/static/bundle/editor-rtl.min.css',
				['ct-main-editor-styles'],
				$theme->get('Version')
			);
		}

		wp_enqueue_script(
			'ct-main-editor-scripts',
			get_template_directory_uri() . '/static/bundle/editor.js',
			['wp-plugins', 'wp-edit-post', 'wp-element', 'wp-hooks', 'ct-options-scripts'],
			$theme->get('Version'),
			true
		);

		$post_type = get_current_screen()->post_type;
		$maybe_cpt = noorgfx_manager()
			->post_types
			->is_supported_post_type();

		if ($maybe_cpt) {
			$post_type = $maybe_cpt;
		}

		$prefix = noorgfx_manager()->screen->get_admin_prefix($post_type);

		$strategy = [
			'strategy' => 'customizer',
			'prefix' => $prefix
		];

		$page_structure_key = 'structure';

		if (function_exists('blc_get_content_block_that_matches')) {
			$single_cb = blc_get_content_block_that_matches([
				'template_type' => 'single',
				'template_subtype' => 'canvas',
				'match_conditions_strategy' => $prefix
			]);

			if ($single_cb) {
				$content_block_atts = noorgfx_get_post_options($single_cb);

				$strategy = [
					'strategy' => $content_block_atts
				];

				$page_structure_key = 'content_block_structure';
			}
		}

		$page_structure = noorgfx_akg_or_customizer(
			$page_structure_key,
			$strategy,
			($prefix === 'single_blog_post') ? 'type-3' : 'type-4'
		);

		$background_source = noorgfx_akg_or_customizer(
			'background',
			$strategy,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
					],
				],
			])
		);

		if (
			isset($background_source['background_type'])
			&&
			$background_source['background_type'] === 'color'
			&&
			isset($background_source['backgroundColor']['default']['color'])
			&&
			$background_source['backgroundColor']['default']['color'] === Noorgfx_Css_Injector::get_skip_rule_keyword()
		) {
			$background_source = noorgfx_get_theme_mod(
				'site_background',
				noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => '#f8f9fb'
						],
					],
				])
			);
		}

		$localize = [
			'post_options' => $options,
			'default_page_structure' => $page_structure,

			'default_background' => $background_source,
			'default_content_style' => noorgfx_akg_or_customizer(
				'content_style',
				$strategy,
				noorgfx_get_content_style_default($prefix)
			),

			'default_content_background' => noorgfx_akg_or_customizer(
				'content_background',
				$strategy,
				noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => '#ffffff'
						],
					],
				])
			),

			'default_boxed_content_spacing' => noorgfx_akg_or_customizer(
				'boxed_content_spacing',
				$strategy,
				[
					'desktop' => noorgfx_spacing_value([
						'top' => '40px',
						'left' => '40px',
						'right' => '40px',
						'bottom' => '40px',
					]),
					'tablet' => noorgfx_spacing_value([
						'top' => '35px',
						'left' => '35px',
						'right' => '35px',
						'bottom' => '35px',
					]),
					'mobile'=> noorgfx_spacing_value([
						'top' => '20px',
						'left' => '20px',
						'right' => '20px',
						'bottom' => '20px',
					]),
				]
			),

			'default_content_boxed_radius' => noorgfx_akg_or_customizer(
				'content_boxed_radius',
				$strategy,
				noorgfx_spacing_value([
					'top' => '3px',
					'left' => '3px',
					'right' => '3px',
					'bottom' => '3px',
				])
			),

			'default_content_boxed_border' => noorgfx_akg_or_customizer(
				'content_boxed_border',
				$strategy,
				[
					'width' => 1,
					'style' => 'none',
					'color' => [
						'color' => 'rgba(44,62,80,0.2)',
					],
				]
			),

			'default_content_boxed_shadow' => noorgfx_akg_or_customizer(
				'content_boxed_shadow',
				$strategy,
				noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 12,
					'blur' => 18,
					'spread' => -6,
					'inset' => false,
					'color' => [
						'color' => 'rgba(34, 56, 101, 0.04)',
					],
				])
			),

			'options_panel_svg' => apply_filters(
				'noorgfx:editor:options:icon',
				'<svg id="b84fcd19-6a6a-48c9-9357-081d427d757c" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
				<rect x="2" y="2" width="44" height="44" rx="3.8" style="fill:#fff"/><path d="M43.2,5A1.8,1.8,0,0,1,45,6.8V43.2A1.8,1.8,0,0,1,43.2,45H6.8A1.8,1.8,0,0,1,5,43.2V6.8A1.8,1.8,0,0,1,6.8,5H43.2m0-4H6.8A5.8,5.8,0,0,0,1,6.8V43.2A5.8,5.8,0,0,0,6.8,49H43.2A5.8,5.8,0,0,0,49,43.2V6.8A5.8,5.8,0,0,0,43.2,1Z" transform="translate(-1 -1)" style="fill:#f7931e"/><polyline points="34 10.7 34 34 14 14 14 37.3" style="fill:#fff;stroke:#f7931e;stroke-miterlimit:10;stroke-width:4px"/>
				</svg>'
			)
		];

		wp_localize_script(
			'ct-main-editor-scripts',
			'ct_editor_localizations',
			$localize
		);
	},
	5
);

add_filter('tiny_mce_before_init', function ($mceInit) {
	if (! isset($mceInit['content_css'])) {
		return $mceInit;
	}

	$parsed = explode(',', $mceInit['content_css']);

	$result = [];

	foreach ($parsed as $file) {
		if (strpos($file, 'noorgfx') !== false) {
			continue;
		}

		$result[] = $file;
	}

	$mceInit['content_css'] = implode(',', $result);

	return $mceInit;
});

add_action(
	'block_editor_settings_all',
	function($settings) {
		$settings['styles'][] = array(
			'css' => noorgfx_manager()->dynamic_css->load_backend_dynamic_css([
				'echo' => false
			]),
			'__unstableType' => 'theme',
			'source' => 'noorgfx'
		);

		return $settings;
	}
);

